/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.support.DefaultQueryCountLogEntryCreator;
import net.ttddyy.dsproxy.support.QueryCountLogEntryCreator;

public abstract class AbstractQueryCountLoggingServletFilter
implements Filter {
    public static final String CLEAR_QUERY_COUNTER_PARAM = "clearQueryCounter";
    public static final String LOG_LEVEL_PARAM = "logLevel";
    public static final String FORMAT_PARAM = "format";
    protected boolean clearQueryCounter = true;
    protected boolean writeAsJson = false;
    protected QueryCountLogEntryCreator logFormatter = new DefaultQueryCountLogEntryCreator();

    public void init(FilterConfig filterConfig) throws ServletException {
        String format;
        String logLevelParam;
        String clearQueryCounterParam = filterConfig.getInitParameter(CLEAR_QUERY_COUNTER_PARAM);
        if (clearQueryCounterParam != null && "false".equalsIgnoreCase(clearQueryCounterParam)) {
            this.clearQueryCounter = false;
        }
        if ((logLevelParam = filterConfig.getInitParameter(LOG_LEVEL_PARAM)) != null) {
            this.initLogLevelFromFilterConfigIfSpecified(logLevelParam);
        }
        if ((format = filterConfig.getInitParameter(FORMAT_PARAM)) != null && "json".equalsIgnoreCase(format)) {
            this.writeAsJson = true;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount count = QueryCountHolder.get(dsName);
            String message = this.writeAsJson ? this.logFormatter.getLogMessageAsJson(dsName, count) : this.logFormatter.getLogMessage(dsName, count);
            this.writeLog(message);
        }
        if (this.clearQueryCounter) {
            QueryCountHolder.clear();
        }
    }

    public void destroy() {
    }

    protected abstract void initLogLevelFromFilterConfigIfSpecified(String var1);

    protected abstract void writeLog(String var1);

    public void setClearQueryCounter(boolean clearQueryCounter) {
        this.clearQueryCounter = clearQueryCounter;
    }

    public void setLogFormatter(QueryCountLogEntryCreator logFormatter) {
        this.logFormatter = logFormatter;
    }

    public void setWriteAsJson(boolean writeAsJson) {
        this.writeAsJson = writeAsJson;
    }
}

