/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.InterceptorHolder;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ObjectArrayUtils;
import net.ttddyy.dsproxy.proxy.StatementMethodNames;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import net.ttddyy.dsproxy.transform.TransformInfo;

public class StatementProxyLogic {
    private static final Set<String> METHODS_TO_INTERCEPT = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(StatementMethodNames.BATCH_PARAM_METHODS);
            this.addAll(StatementMethodNames.EXEC_METHODS);
            this.addAll(StatementMethodNames.JDBC4_METHODS);
            this.addAll(StatementMethodNames.GET_CONNECTION_METHOD);
            this.add("getDataSourceName");
            this.add("toString");
            this.add("getTarget");
        }
    });
    private Statement stmt;
    private InterceptorHolder interceptorHolder;
    private String dataSourceName;
    private List<String> batchQueries = new ArrayList<String>();
    private JdbcProxyFactory jdbcProxyFactory = JdbcProxyFactory.DEFAULT;

    public StatementProxyLogic() {
    }

    public StatementProxyLogic(Statement stmt, InterceptorHolder interceptorHolder, String dataSourceName, JdbcProxyFactory jdbcProxyFactory) {
        this.stmt = stmt;
        this.interceptorHolder = interceptorHolder;
        this.dataSourceName = dataSourceName;
        this.jdbcProxyFactory = jdbcProxyFactory;
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.stmt, args);
        }
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.stmt.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.stmt.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.stmt;
        }
        if (StatementMethodNames.JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.stmt.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.stmt.isWrapperFor(clazz);
            }
        }
        if (StatementMethodNames.GET_CONNECTION_METHOD.contains(methodName)) {
            Connection conn = (Connection)MethodUtils.proceedExecution(method, this.stmt, args);
            return this.jdbcProxyFactory.createConnection(conn, this.interceptorHolder, this.dataSourceName);
        }
        if ("addBatch".equals(methodName) || "clearBatch".equals(methodName)) {
            if ("addBatch".equals(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
                QueryTransformer queryTransformer = this.interceptorHolder.getQueryTransformer();
                String query = (String)args[0];
                Class<Statement> clazz = Statement.class;
                int batchCount = this.batchQueries.size();
                TransformInfo transformInfo = new TransformInfo(clazz, this.dataSourceName, query, true, batchCount);
                String transformedQuery = queryTransformer.transformQuery(transformInfo);
                args[0] = transformedQuery;
                this.batchQueries.add(transformedQuery);
            } else if ("clearBatch".equals(methodName)) {
                this.batchQueries.clear();
            }
            try {
                return method.invoke((Object)this.stmt, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        boolean isBatchExecute = false;
        int batchSize = 0;
        if (StatementMethodNames.BATCH_EXEC_METHODS.contains(methodName)) {
            for (String batchQuery : this.batchQueries) {
                queries.add(new QueryInfo(batchQuery));
            }
            batchSize = this.batchQueries.size();
            this.batchQueries.clear();
            isBatchExecute = true;
        } else if (StatementMethodNames.QUERY_EXEC_METHODS.contains(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
            QueryTransformer queryTransformer = this.interceptorHolder.getQueryTransformer();
            String query = (String)args[0];
            TransformInfo transformInfo = new TransformInfo(Statement.class, this.dataSourceName, query, false, 0);
            String transformedQuery = queryTransformer.transformQuery(transformInfo);
            args[0] = transformedQuery;
            queries.add(new QueryInfo(transformedQuery));
        }
        ExecutionInfo execInfo = new ExecutionInfo(this.dataSourceName, this.stmt, isBatchExecute, batchSize, method, args);
        QueryExecutionListener listener = this.interceptorHolder.getListener();
        listener.beforeQuery(execInfo, queries);
        try {
            long beforeTime = System.currentTimeMillis();
            Object retVal = method.invoke((Object)this.stmt, args);
            long afterTime = System.currentTimeMillis();
            execInfo.setResult(retVal);
            execInfo.setElapsedTime(afterTime - beforeTime);
            execInfo.setSuccess(true);
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException ex) {
            execInfo.setThrowable(ex.getTargetException());
            execInfo.setSuccess(false);
            throw ex.getTargetException();
        }
        finally {
            listener.afterQuery(execInfo, queries);
        }
    }
}

