/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.proxy.InterceptorHolder;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.ObjectArrayUtils;
import net.ttddyy.dsproxy.transform.TransformInfo;

public class ConnectionProxyLogic {
    private static final Set<String> JDBC4_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unwrap", "isWrapperFor")));
    private Connection connection;
    private InterceptorHolder interceptorHolder;
    private ConnectionInfo connectionInfo;
    private JdbcProxyFactory jdbcProxyFactory = JdbcProxyFactory.DEFAULT;

    public ConnectionProxyLogic() {
    }

    public ConnectionProxyLogic(Connection connection, InterceptorHolder interceptorHolder, ConnectionInfo connectionInfo, JdbcProxyFactory jdbcProxyFactory) {
        this.connection = connection;
        this.interceptorHolder = interceptorHolder;
        this.connectionInfo = connectionInfo;
        this.jdbcProxyFactory = jdbcProxyFactory;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String query;
        Object retVal;
        Connection proxyConnection = (Connection)proxy;
        String methodName = method.getName();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.connection.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.connection.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.connectionInfo.getDataSourceName();
        }
        if ("getTarget".equals(methodName)) {
            return this.connection;
        }
        if (JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.connection.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.connection.isWrapperFor(clazz);
            }
        }
        if (("prepareStatement".equals(methodName) || "prepareCall".equals(methodName)) && ObjectArrayUtils.isFirstArgString(args)) {
            String query2 = (String)args[0];
            Class clazz = "prepareStatement".equals(methodName) ? PreparedStatement.class : CallableStatement.class;
            TransformInfo transformInfo = new TransformInfo(clazz, this.connectionInfo.getDataSourceName(), query2, false, 0);
            String transformedQuery = this.interceptorHolder.getQueryTransformer().transformQuery(transformInfo);
            args[0] = transformedQuery;
        }
        try {
            retVal = method.invoke((Object)this.connection, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        if ("createStatement".equals(methodName)) {
            return this.jdbcProxyFactory.createStatement((Statement)retVal, this.interceptorHolder, this.connectionInfo, proxyConnection);
        }
        if ("prepareStatement".equals(methodName)) {
            if (ObjectArrayUtils.isFirstArgString(args)) {
                query = (String)args[0];
                return this.jdbcProxyFactory.createPreparedStatement((PreparedStatement)retVal, query, this.interceptorHolder, this.connectionInfo, proxyConnection);
            }
        } else if ("prepareCall".equals(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
            query = (String)args[0];
            return this.jdbcProxyFactory.createCallableStatement((CallableStatement)retVal, query, this.interceptorHolder, this.connectionInfo, proxyConnection);
        }
        return retVal;
    }
}

