/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.sql.Connection;
import net.ttddyy.dsproxy.ConnectionIdManager;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ProxyConnectionAdvice
implements MethodInterceptor {
    private JdbcProxyFactory jdbcProxyFactory = JdbcProxyFactory.DEFAULT;
    private ConnectionIdManager connectionIdManager = ConnectionIdManager.DEFAULT;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retVal = invocation.proceed();
        if (!(retVal instanceof Connection)) {
            return retVal;
        }
        Connection conn = (Connection)retVal;
        long connId = this.connectionIdManager.getId(conn);
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setConnectionId(connId);
        connectionInfo.setDataSourceName("");
        return this.jdbcProxyFactory.createConnection((Connection)retVal, null, connectionInfo);
    }

    public JdbcProxyFactory getJdbcProxyFactory() {
        return this.jdbcProxyFactory;
    }

    public void setJdbcProxyFactory(JdbcProxyFactory jdbcProxyFactory) {
        this.jdbcProxyFactory = jdbcProxyFactory;
    }

    public ConnectionIdManager getConnectionIdManager() {
        return this.connectionIdManager;
    }

    public void setConnectionIdManager(ConnectionIdManager connectionIdManager) {
        this.connectionIdManager = connectionIdManager;
    }
}

