/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ConnectionIdManager;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionListenerUtils;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.ProxyConfig;

public class DataSourceProxyLogic {
    private static final Set<String> JDBC4_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unwrap", "isWrapperFor")));
    private DataSource dataSource;
    private ProxyConfig proxyConfig;

    public DataSourceProxyLogic(DataSource dataSource, ProxyConfig proxyConfig) {
        this.dataSource = dataSource;
        this.proxyConfig = proxyConfig;
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        return MethodExecutionListenerUtils.invoke(new MethodExecutionListenerUtils.MethodExecutionCallback(){

            @Override
            public Object execute(Object proxy, Method method, Object[] args) throws Throwable {
                return DataSourceProxyLogic.this.performQueryExecutionListener(method, args);
            }
        }, this.proxyConfig, this.dataSource, method, args);
    }

    private Object performQueryExecutionListener(Method method, Object[] args) throws Throwable {
        String dataSourceName = this.proxyConfig.getDataSourceName();
        JdbcProxyFactory jdbcProxyFactory = this.proxyConfig.getJdbcProxyFactory();
        ConnectionIdManager connectionIdManager = this.proxyConfig.getConnectionIdManager();
        String methodName = method.getName();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.dataSource.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.dataSource.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.dataSource;
        }
        if (JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.dataSource.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.dataSource.isWrapperFor(clazz);
            }
        }
        try {
            Object retVal = method.invoke((Object)this.dataSource, args);
            if ("getConnection".equals(methodName)) {
                Connection conn = (Connection)retVal;
                long connId = connectionIdManager.getId(conn);
                ConnectionInfo connectionInfo = new ConnectionInfo();
                connectionInfo.setConnectionId(connId);
                connectionInfo.setDataSourceName(dataSourceName);
                return jdbcProxyFactory.createConnection((Connection)retVal, connectionInfo, this.proxyConfig);
            }
            return retVal;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

