/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import net.ttddyy.dsproxy.listener.MethodExecutionListenerUtils;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ProxyConfig;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogic;

public class SimpleResultSetProxyLogic
implements ResultSetProxyLogic {
    private ResultSet resultSet;
    private ProxyConfig proxyConfig;

    public SimpleResultSetProxyLogic(ResultSet resultSet, ProxyConfig proxyConfig) {
        this.resultSet = resultSet;
        this.proxyConfig = proxyConfig;
    }

    @Override
    public Object invoke(Method method, Object[] args) throws Throwable {
        return MethodExecutionListenerUtils.invoke(new MethodExecutionListenerUtils.MethodExecutionCallback(){

            @Override
            public Object execute(Object proxyTarget, Method method, Object[] args) throws Throwable {
                return SimpleResultSetProxyLogic.this.performQueryExecutionListener(method, args);
            }
        }, this.proxyConfig, this.resultSet, method, args);
    }

    private Object performQueryExecutionListener(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.resultSet.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.resultSet.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getTarget".equals(methodName)) {
            return this.resultSet;
        }
        return MethodUtils.proceedExecution(method, this.resultSet, args);
    }
}

