/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionListenerUtils;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.ObjectArrayUtils;
import net.ttddyy.dsproxy.proxy.ProxyConfig;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import net.ttddyy.dsproxy.transform.TransformInfo;

public class ConnectionProxyLogic {
    private static final Set<String> JDBC4_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unwrap", "isWrapperFor")));
    private Connection connection;
    private ConnectionInfo connectionInfo;
    private ProxyConfig proxyConfig;

    public ConnectionProxyLogic(Connection connection, ConnectionInfo connectionInfo, ProxyConfig proxyConfig) {
        this.connection = connection;
        this.connectionInfo = connectionInfo;
        this.proxyConfig = proxyConfig;
    }

    public Object invoke(final Object proxyConnection, Method method, Object[] args) throws Throwable {
        final boolean isCloseMethod = "close".equals(method.getName());
        final boolean isCommitMethod = "commit".equals(method.getName());
        final boolean isRollbackMethod = "rollback".equals(method.getName());
        return MethodExecutionListenerUtils.invoke(new MethodExecutionListenerUtils.MethodExecutionCallback(){

            @Override
            public Object execute(Object proxyTarget, Method method, Object[] args) throws Throwable {
                Object result = ConnectionProxyLogic.this.performQueryExecutionListener(proxyConnection, method, args);
                ConnectionInfo connectionInfo = ConnectionProxyLogic.this.connectionInfo;
                if (isCommitMethod) {
                    connectionInfo.incrementCommitCount();
                } else if (isRollbackMethod) {
                    connectionInfo.incrementRollbackCount();
                } else if (isCloseMethod) {
                    connectionInfo.setClosed(true);
                    long connId = connectionInfo.getConnectionId();
                    ConnectionProxyLogic.this.proxyConfig.getConnectionIdManager().addClosedId(connId);
                }
                return result;
            }
        }, this.proxyConfig, this.connection, this.connectionInfo, method, args);
    }

    private Object performQueryExecutionListener(Object proxy, Method method, Object[] args) throws Throwable {
        String query;
        Object retVal;
        Connection proxyConnection = (Connection)proxy;
        String methodName = method.getName();
        QueryTransformer queryTransformer = this.proxyConfig.getQueryTransformer();
        JdbcProxyFactory jdbcProxyFactory = this.proxyConfig.getJdbcProxyFactory();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.connection.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.connection.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.connectionInfo.getDataSourceName();
        }
        if ("getTarget".equals(methodName)) {
            return this.connection;
        }
        if (JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.connection.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.connection.isWrapperFor(clazz);
            }
        }
        if (("prepareStatement".equals(methodName) || "prepareCall".equals(methodName)) && ObjectArrayUtils.isFirstArgString(args)) {
            String query2 = (String)args[0];
            Class clazz = "prepareStatement".equals(methodName) ? PreparedStatement.class : CallableStatement.class;
            TransformInfo transformInfo = new TransformInfo(clazz, this.connectionInfo.getDataSourceName(), query2, false, 0);
            String transformedQuery = queryTransformer.transformQuery(transformInfo);
            args[0] = transformedQuery;
        }
        try {
            retVal = method.invoke((Object)this.connection, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        if ("createStatement".equals(methodName)) {
            return jdbcProxyFactory.createStatement((Statement)retVal, this.connectionInfo, proxyConnection, this.proxyConfig);
        }
        if ("prepareStatement".equals(methodName)) {
            if (ObjectArrayUtils.isFirstArgString(args)) {
                query = (String)args[0];
                return jdbcProxyFactory.createPreparedStatement((PreparedStatement)retVal, query, this.connectionInfo, proxyConnection, this.proxyConfig);
            }
        } else if ("prepareCall".equals(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
            query = (String)args[0];
            return jdbcProxyFactory.createCallableStatement((CallableStatement)retVal, query, this.connectionInfo, proxyConnection, this.proxyConfig);
        }
        return retVal;
    }
}

