/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionListenerUtils;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ProxyConfig;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogic;

public class RepeatableReadResultSetProxyLogic
implements ResultSetProxyLogic {
    private static final Set<String> METHODS_TO_INTERCEPT = Collections.unmodifiableSet(new HashSet<String>(){
        {
            for (Method method : ResultSet.class.getDeclaredMethods()) {
                this.add(method.getName());
            }
            this.add("toString");
            this.add("getTarget");
        }
    });
    private Map<String, Integer> columnNameToIndex;
    private ResultSet resultSet;
    private ConnectionInfo connectionInfo;
    private int columnCount;
    private ProxyConfig proxyConfig;
    private int resultPointer;
    private boolean resultSetConsumed;
    private boolean closed;
    private Object[] currentResult;
    private final List<Object[]> cachedResults = new ArrayList<Object[]>();

    @Override
    public Object invoke(Method method, Object[] args) throws Throwable {
        return MethodExecutionListenerUtils.invoke(new MethodExecutionListenerUtils.MethodExecutionCallback(){

            @Override
            public Object execute(Object proxyTarget, Method method, Object[] args) throws Throwable {
                return RepeatableReadResultSetProxyLogic.this.performQueryExecutionListener(method, args);
            }
        }, this.proxyConfig, this.resultSet, this.connectionInfo, method, args);
    }

    private Object performQueryExecutionListener(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.resultSet, args);
        }
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.resultSet.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.resultSet.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getTarget".equals(methodName)) {
            return this.resultSet;
        }
        if (methodName.equals("getMetaData")) {
            return method.invoke((Object)this.resultSet, args);
        }
        if (methodName.equals("close")) {
            this.closed = true;
            return method.invoke((Object)this.resultSet, args);
        }
        if (methodName.equals("isClosed")) {
            return method.invoke((Object)this.resultSet, args);
        }
        if (this.closed) {
            throw new SQLException("Already closed");
        }
        if (this.resultSetConsumed) {
            if (this.isGetMethod(method)) {
                return this.handleGetMethodUsingCache(args);
            }
            if (this.isNextMethod(method)) {
                return this.handleNextMethodUsingCache();
            }
        } else {
            if (this.isGetMethod(method)) {
                return this.handleGetMethodByDelegating(method, args);
            }
            if (this.isNextMethod(method)) {
                return this.handleNextMethodByDelegating(method, args);
            }
            if (this.isBeforeFirstMethod(method)) {
                this.resultPointer = -1;
                this.resultSetConsumed = true;
                return null;
            }
        }
        throw new UnsupportedOperationException(String.format("Method '%s' is not supported by this proxy", method));
    }

    private Object handleNextMethodByDelegating(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object result = method.invoke((Object)this.resultSet, args);
        if (Boolean.TRUE.equals(result)) {
            this.currentResult = new Object[this.columnCount + 1];
            this.cachedResults.add(this.currentResult);
        }
        return result;
    }

    private Object handleGetMethodByDelegating(Method method, Object[] args) throws SQLException, IllegalAccessException, InvocationTargetException {
        Object result;
        int columnIndex = this.determineColumnIndex(args);
        this.currentResult[columnIndex] = result = method.invoke((Object)this.resultSet, args);
        return result;
    }

    private Object handleNextMethodUsingCache() {
        if (this.resultPointer < this.cachedResults.size() - 1) {
            ++this.resultPointer;
            this.currentResult = this.cachedResults.get(this.resultPointer);
            return true;
        }
        ++this.resultPointer;
        this.currentResult = null;
        return false;
    }

    private Object handleGetMethodUsingCache(Object[] args) throws SQLException {
        if (this.resultPointer == -1) {
            throw new SQLException("Result set not advanced. Call next before any get method!");
        }
        if (this.resultPointer < this.cachedResults.size()) {
            int columnIndex = this.determineColumnIndex(args);
            return this.currentResult[columnIndex];
        }
        throw new SQLException(String.format("Result set exhausted. There were %d result(s) only", this.cachedResults.size()));
    }

    private boolean isGetMethod(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length > 0;
    }

    private boolean isNextMethod(Method method) {
        return method.getName().equals("next");
    }

    private boolean isBeforeFirstMethod(Method method) {
        return method.getName().equals("beforeFirst");
    }

    private int determineColumnIndex(Object[] args) throws SQLException {
        Object lookup = args[0];
        if (lookup instanceof Integer) {
            return (Integer)lookup;
        }
        String columnName = (String)lookup;
        Integer indexForColumnName = this.columnNameToIndex(columnName);
        if (indexForColumnName != null) {
            return indexForColumnName;
        }
        throw new SQLException(String.format("Unknown column name '%s'", columnName));
    }

    private Integer columnNameToIndex(String columnName) {
        return this.columnNameToIndex.get(columnName.toUpperCase());
    }

    public static class Builder {
        private ResultSet resultSet;
        private ConnectionInfo connectionInfo;
        private ProxyConfig proxyConfig;
        private Map<String, Integer> columnNameToIndex;
        private int columnCount;

        public static Builder create() {
            return new Builder();
        }

        public RepeatableReadResultSetProxyLogic build() {
            RepeatableReadResultSetProxyLogic logic = new RepeatableReadResultSetProxyLogic();
            logic.resultSet = this.resultSet;
            logic.connectionInfo = this.connectionInfo;
            logic.proxyConfig = this.proxyConfig;
            logic.columnNameToIndex = this.columnNameToIndex;
            logic.columnCount = this.columnCount;
            return logic;
        }

        public Builder resultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
            return this;
        }

        public Builder connectionInfo(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public Builder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public Builder columnNameToIndex(Map<String, Integer> columnNameToIndex) {
            this.columnNameToIndex = columnNameToIndex;
            return this;
        }

        public Builder columnCount(int columnCount) {
            this.columnCount = columnCount;
            return this;
        }
    }
}

