/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener.logging;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.ttddyy.dsproxy.StatementType;
import net.ttddyy.dsproxy.listener.logging.ParameterValueConverter;
import net.ttddyy.dsproxy.listener.logging.QueryLogEntryCreator;
import net.ttddyy.dsproxy.listener.logging.RegisterOutParameterValueConverter;
import net.ttddyy.dsproxy.listener.logging.SetNullParameterValueConverter;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;

public abstract class AbstractQueryLogEntryCreator
implements QueryLogEntryCreator {
    protected static final Map<Character, String> JSON_SPECIAL_CHARS = new HashMap<Character, String>();
    protected ParameterValueConverter setNullParameterValueConverter = new SetNullParameterValueConverter();
    protected ParameterValueConverter registerOutParameterValueConverter = new RegisterOutParameterValueConverter();

    protected void chompIfEndWith(StringBuilder sb, char c) {
        int lastCharIndex = sb.length() - 1;
        if (sb.charAt(lastCharIndex) == c) {
            sb.deleteCharAt(lastCharIndex);
        }
    }

    protected String getStatementType(StatementType statementType) {
        if (StatementType.STATEMENT.equals((Object)statementType)) {
            return "Statement";
        }
        if (StatementType.PREPARED.equals((Object)statementType)) {
            return "Prepared";
        }
        if (StatementType.CALLABLE.equals((Object)statementType)) {
            return "Callable";
        }
        return "Unknown";
    }

    protected SortedMap<String, String> getParametersToDisplay(List<ParameterSetOperation> params) {
        TreeMap<String, String> paramMap = new TreeMap<String, String>(new StringAsIntegerComparator());
        for (ParameterSetOperation param : params) {
            String key = this.getParameterKeyToDisplay(param);
            String value = this.getParameterValueToDisplay(param);
            paramMap.put(key, value);
        }
        return paramMap;
    }

    public String getParameterKeyToDisplay(ParameterSetOperation param) {
        Object key = param.getArgs()[0];
        return key instanceof String ? (String)key : key.toString();
    }

    protected String getParameterValueToDisplay(ParameterSetOperation param) {
        String value = ParameterSetOperation.isSetNullParameterOperation(param) ? this.getDisplayValueForSetNull(param) : (ParameterSetOperation.isRegisterOutParameterOperation(param) ? this.getDisplayValueForRegisterOutParameter(param) : this.getDisplayValue(param));
        return value;
    }

    public String getDisplayValueForSetNull(ParameterSetOperation param) {
        return this.setNullParameterValueConverter.getValue(param);
    }

    public String getDisplayValueForRegisterOutParameter(ParameterSetOperation param) {
        return this.registerOutParameterValueConverter.getValue(param);
    }

    public String getDisplayValue(ParameterSetOperation param) {
        return param.getArgs()[1].toString();
    }

    public void setSetNullParameterValueConverter(ParameterValueConverter setNullParameterValueConverter) {
        this.setNullParameterValueConverter = setNullParameterValueConverter;
    }

    public void setRegisterOutParameterValueConverter(ParameterValueConverter registerOutParameterValueConverter) {
        this.registerOutParameterValueConverter = registerOutParameterValueConverter;
    }

    static {
        JSON_SPECIAL_CHARS.put(Character.valueOf('\"'), "\\\"");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\\'), "\\\\");
        JSON_SPECIAL_CHARS.put(Character.valueOf('/'), "\\/");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\b'), "\\b");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\f'), "\\f");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\n'), "\\n");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\r'), "\\r");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\t'), "\\t");
    }

    protected static class StringAsIntegerComparator
    implements Comparator<String> {
        protected StringAsIntegerComparator() {
        }

        @Override
        public int compare(String left, String right) {
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            try {
                int leftInt = Integer.parseInt(left);
                int rightInt = Integer.parseInt(right);
                return leftInt < rightInt ? -1 : (leftInt == rightInt ? 0 : 1);
            }
            catch (NumberFormatException e) {
                return left.compareTo(right);
            }
        }
    }
}

