/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener.logging;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.StatementType;
import net.ttddyy.dsproxy.listener.logging.AbstractQueryLogEntryCreator;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;

public class DefaultQueryLogEntryCreator
extends AbstractQueryLogEntryCreator {
    @Override
    public String getLogEntry(ExecutionInfo execInfo, List<QueryInfo> queryInfoList, boolean writeDataSourceName) {
        StringBuilder sb = new StringBuilder();
        if (writeDataSourceName) {
            this.writeDataSourceNameEntry(sb, execInfo, queryInfoList);
        }
        this.writeTimeEntry(sb, execInfo, queryInfoList);
        this.writeResultEntry(sb, execInfo, queryInfoList);
        this.writeTypeEntry(sb, execInfo, queryInfoList);
        this.writeBatchEntry(sb, execInfo, queryInfoList);
        this.writeQuerySizeEntry(sb, execInfo, queryInfoList);
        this.writeBatchSizeEntry(sb, execInfo, queryInfoList);
        this.writeQueriesEntry(sb, execInfo, queryInfoList);
        this.writeParamsEntry(sb, execInfo, queryInfoList);
        return sb.toString();
    }

    protected void writeDataSourceNameEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        String name = execInfo.getDataSourceName();
        sb.append("Name:");
        sb.append(name == null ? "" : name);
        sb.append(", ");
    }

    protected void writeTimeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Time:");
        sb.append(execInfo.getElapsedTime());
        sb.append(", ");
    }

    protected void writeResultEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Success:");
        sb.append(execInfo.isSuccess() ? "True" : "False");
        sb.append(", ");
    }

    protected void writeTypeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Type:");
        sb.append(this.getStatementType(execInfo.getStatementType()));
        sb.append(", ");
    }

    protected void writeBatchEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Batch:");
        sb.append(execInfo.isBatch() ? "True" : "False");
        sb.append(", ");
    }

    protected void writeQuerySizeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("QuerySize:");
        sb.append(queryInfoList.size());
        sb.append(", ");
    }

    protected void writeBatchSizeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("BatchSize:");
        sb.append(execInfo.getBatchSize());
        sb.append(", ");
    }

    protected void writeQueriesEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Query:[");
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("\"");
            sb.append(queryInfo.getQuery());
            sb.append("\",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("], ");
    }

    protected void writeParamsEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        boolean isPrepared = execInfo.getStatementType() == StatementType.PREPARED;
        sb.append("Params:[");
        for (QueryInfo queryInfo : queryInfoList) {
            for (List<ParameterSetOperation> parameters : queryInfo.getParametersList()) {
                SortedMap<String, String> paramMap = this.getParametersToDisplay(parameters);
                if (isPrepared) {
                    this.writeParamsForSinglePreparedEntry(sb, paramMap, execInfo, queryInfoList);
                    continue;
                }
                this.writeParamsForSingleCallableEntry(sb, paramMap, execInfo, queryInfoList);
            }
        }
        this.chompIfEndWith(sb, ',');
        sb.append("]");
    }

    protected void writeParamsForSinglePreparedEntry(StringBuilder sb, SortedMap<String, String> paramMap, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("(");
        for (Map.Entry<String, String> paramEntry : paramMap.entrySet()) {
            sb.append(paramEntry.getValue());
            sb.append(",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("),");
    }

    protected void writeParamsForSingleCallableEntry(StringBuilder sb, SortedMap<String, String> paramMap, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("(");
        for (Map.Entry<String, String> paramEntry : paramMap.entrySet()) {
            sb.append(paramEntry.getKey());
            sb.append("=");
            sb.append(paramEntry.getValue());
            sb.append(",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("),");
    }
}

