/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.support.DefaultQueryCountLogEntryCreator;
import net.ttddyy.dsproxy.support.QueryCountLogEntryCreator;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class AbstractQueryCountLoggingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private boolean clearQueryCounter = true;
    private boolean writeAsJson = false;
    private QueryCountLogEntryCreator logFormatter = new DefaultQueryCountLogEntryCreator();

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount count = QueryCountHolder.get(dsName);
            String logEntry = this.writeAsJson ? this.logFormatter.getLogMessageAsJson(dsName, count) : this.logFormatter.getLogMessage(dsName, count);
            this.writeLog(logEntry);
        }
        if (this.clearQueryCounter) {
            QueryCountHolder.clear();
        }
    }

    protected abstract void writeLog(String var1);

    public void setClearQueryCounter(boolean clearQueryCounter) {
        this.clearQueryCounter = clearQueryCounter;
    }

    public void setLogFormatter(QueryCountLogEntryCreator logFormatter) {
        this.logFormatter = logFormatter;
    }

    public void setWriteAsJson(boolean writeAsJson) {
        this.writeAsJson = writeAsJson;
    }
}

