/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.DataSourceQueryCountListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.logging.AbstractQueryLoggingListener;
import net.ttddyy.dsproxy.listener.logging.CommonsLogLevel;
import net.ttddyy.dsproxy.listener.logging.CommonsQueryLoggingListener;
import net.ttddyy.dsproxy.listener.logging.DefaultJsonQueryLogEntryCreator;
import net.ttddyy.dsproxy.listener.logging.JULQueryLoggingListener;
import net.ttddyy.dsproxy.listener.logging.SLF4JLogLevel;
import net.ttddyy.dsproxy.listener.logging.SLF4JQueryLoggingListener;
import net.ttddyy.dsproxy.listener.logging.SystemOutQueryLoggingListener;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.QueryTransformer;

public class ProxyDataSourceBuilder {
    private DataSource dataSource;
    private String dataSourceName;
    private boolean createCommonsQueryListener;
    private CommonsLogLevel commonsLogLevel;
    private String commonsLoggerName;
    private boolean createSlf4jQueryListener;
    private SLF4JLogLevel slf4jLogLevel;
    private String slf4jLoggerName;
    private boolean createJULQueryListener;
    private Level julLogLevel;
    private String julLoggerName;
    private boolean createSysOutQueryListener;
    private boolean createDataSourceQueryCountListener;
    private boolean jsonFormat;
    private List<QueryExecutionListener> queryExecutionListeners = new ArrayList<QueryExecutionListener>();
    private ParameterTransformer parameterTransformer;
    private QueryTransformer queryTransformer;

    public static ProxyDataSourceBuilder create() {
        return new ProxyDataSourceBuilder();
    }

    public static ProxyDataSourceBuilder create(DataSource dataSource) {
        return new ProxyDataSourceBuilder(dataSource);
    }

    public static ProxyDataSourceBuilder create(String dataSourceName, DataSource dataSource) {
        return new ProxyDataSourceBuilder(dataSource).name(dataSourceName);
    }

    public ProxyDataSourceBuilder() {
    }

    public ProxyDataSourceBuilder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ProxyDataSourceBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByCommons() {
        this.createCommonsQueryListener = true;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByCommons(CommonsLogLevel logLevel) {
        this.createCommonsQueryListener = true;
        this.commonsLogLevel = logLevel;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByCommons(String commonsLoggerName) {
        this.createCommonsQueryListener = true;
        this.commonsLoggerName = commonsLoggerName;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByCommons(CommonsLogLevel logLevel, String commonsLoggerName) {
        this.createCommonsQueryListener = true;
        this.commonsLogLevel = logLevel;
        this.commonsLoggerName = commonsLoggerName;
        return this;
    }

    public ProxyDataSourceBuilder logQueryBySlf4j() {
        this.createSlf4jQueryListener = true;
        return this;
    }

    public ProxyDataSourceBuilder logQueryBySlf4j(SLF4JLogLevel logLevel) {
        this.createSlf4jQueryListener = true;
        this.slf4jLogLevel = logLevel;
        return this;
    }

    public ProxyDataSourceBuilder logQueryBySlf4j(String slf4jLoggerName) {
        this.createSlf4jQueryListener = true;
        this.slf4jLoggerName = slf4jLoggerName;
        return this;
    }

    public ProxyDataSourceBuilder logQueryBySlf4j(SLF4JLogLevel logLevel, String slf4jLoggerName) {
        this.createSlf4jQueryListener = true;
        this.slf4jLogLevel = logLevel;
        this.slf4jLoggerName = slf4jLoggerName;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByJUL() {
        this.createJULQueryListener = true;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByJUL(Level logLevel) {
        this.createJULQueryListener = true;
        this.julLogLevel = logLevel;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByJUL(String julLoggerName) {
        this.createJULQueryListener = true;
        this.julLoggerName = julLoggerName;
        return this;
    }

    public ProxyDataSourceBuilder logQueryByJUL(Level logLevel, String julLoggerName) {
        this.createJULQueryListener = true;
        this.julLogLevel = logLevel;
        this.julLoggerName = julLoggerName;
        return this;
    }

    public ProxyDataSourceBuilder logQueryToSysOut() {
        this.createSysOutQueryListener = true;
        return this;
    }

    public ProxyDataSourceBuilder countQuery() {
        this.createDataSourceQueryCountListener = true;
        return this;
    }

    public ProxyDataSourceBuilder listener(QueryExecutionListener listener) {
        this.queryExecutionListeners.add(listener);
        return this;
    }

    public ProxyDataSourceBuilder asJson() {
        this.jsonFormat = true;
        return this;
    }

    public ProxyDataSourceBuilder name(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public ProxyDataSourceBuilder queryTransformer(QueryTransformer queryTransformer) {
        this.queryTransformer = queryTransformer;
        return this;
    }

    public ProxyDataSourceBuilder parameterTransformer(ParameterTransformer parameterTransformer) {
        this.parameterTransformer = parameterTransformer;
        return this;
    }

    public ProxyDataSource build() {
        AbstractQueryLoggingListener listener;
        ProxyDataSource proxyDataSource = new ProxyDataSource();
        if (this.dataSource != null) {
            proxyDataSource.setDataSource(this.dataSource);
        }
        if (this.dataSourceName != null) {
            proxyDataSource.setDataSourceName(this.dataSourceName);
        }
        ArrayList<QueryExecutionListener> listeners = new ArrayList<QueryExecutionListener>();
        if (this.createCommonsQueryListener) {
            listener = new CommonsQueryLoggingListener();
            if (this.commonsLogLevel != null) {
                ((CommonsQueryLoggingListener)listener).setLogLevel(this.commonsLogLevel);
            }
            if (this.commonsLoggerName != null && !this.commonsLoggerName.isEmpty()) {
                listener.setLoggerName(this.commonsLoggerName);
            }
            if (this.jsonFormat) {
                listener.setQueryLogEntryCreator(new DefaultJsonQueryLogEntryCreator());
            }
            listeners.add(listener);
        }
        if (this.createSlf4jQueryListener) {
            listener = new SLF4JQueryLoggingListener();
            if (this.slf4jLogLevel != null) {
                ((SLF4JQueryLoggingListener)listener).setLogLevel(this.slf4jLogLevel);
            }
            if (this.slf4jLoggerName != null && !this.slf4jLoggerName.isEmpty()) {
                listener.setLoggerName(this.slf4jLoggerName);
            }
            if (this.jsonFormat) {
                listener.setQueryLogEntryCreator(new DefaultJsonQueryLogEntryCreator());
            }
            listeners.add(listener);
        }
        if (this.createJULQueryListener) {
            listener = new JULQueryLoggingListener();
            if (this.julLogLevel != null) {
                ((JULQueryLoggingListener)listener).setLogLevel(this.julLogLevel);
            }
            if (this.julLoggerName != null && !this.julLoggerName.isEmpty()) {
                listener.setLoggerName(this.julLoggerName);
            }
            if (this.jsonFormat) {
                listener.setQueryLogEntryCreator(new DefaultJsonQueryLogEntryCreator());
            }
            listeners.add(listener);
        }
        if (this.createSysOutQueryListener) {
            listener = new SystemOutQueryLoggingListener();
            if (this.jsonFormat) {
                listener.setQueryLogEntryCreator(new DefaultJsonQueryLogEntryCreator());
            }
            listeners.add(listener);
        }
        if (this.createDataSourceQueryCountListener) {
            listeners.add(new DataSourceQueryCountListener());
        }
        listeners.addAll(this.queryExecutionListeners);
        for (QueryExecutionListener listener2 : listeners) {
            proxyDataSource.addListener(listener2);
        }
        if (this.queryTransformer != null) {
            proxyDataSource.getInterceptorHolder().setQueryTransformer(this.queryTransformer);
        }
        if (this.parameterTransformer != null) {
            proxyDataSource.getInterceptorHolder().setParameterTransformer(this.parameterTransformer);
        }
        return proxyDataSource;
    }
}

