/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import net.ttddyy.dsproxy.listener.logging.SLF4JLogLevel;
import net.ttddyy.dsproxy.support.AbstractQueryCountLoggingRequestListener;
import net.ttddyy.dsproxy.support.SLF4JLogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JQueryCountLoggingRequestListener
extends AbstractQueryCountLoggingRequestListener {
    private static final String LOG_LEVEL_PARAM = "queryCountSLF4JLogLevel";
    private static final SLF4JLogLevel DEFAULT_LOG_LEVEL = SLF4JLogLevel.DEBUG;
    private Logger logger = LoggerFactory.getLogger(SLF4JQueryCountLoggingRequestListener.class);

    @Override
    protected void writeLog(ServletRequestEvent servletRequestEvent, String logEntry) {
        ServletContext context = servletRequestEvent.getServletContext();
        String logLevelParam = context.getInitParameter(LOG_LEVEL_PARAM);
        SLF4JLogLevel logLevel = SLF4JLogLevel.nullSafeValueOf(logLevelParam);
        if (logLevel == null) {
            logLevel = DEFAULT_LOG_LEVEL;
        }
        SLF4JLogUtils.writeLog(this.logger, logLevel, logEntry);
    }
}

