/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy;

import java.util.concurrent.atomic.AtomicLong;
import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.StatementType;

public class QueryCount {
    private AtomicLong select = new AtomicLong();
    private AtomicLong insert = new AtomicLong();
    private AtomicLong update = new AtomicLong();
    private AtomicLong delete = new AtomicLong();
    private AtomicLong other = new AtomicLong();
    private AtomicLong statement = new AtomicLong();
    private AtomicLong prepared = new AtomicLong();
    private AtomicLong callable = new AtomicLong();
    private AtomicLong total = new AtomicLong();
    private AtomicLong failure = new AtomicLong();
    private AtomicLong success = new AtomicLong();
    private AtomicLong time = new AtomicLong();

    public void increment(QueryType queryType) {
        switch (queryType) {
            case SELECT: {
                this.incrementSelect();
                break;
            }
            case INSERT: {
                this.incrementInsert();
                break;
            }
            case UPDATE: {
                this.incrementUpdate();
                break;
            }
            case DELETE: {
                this.incrementDelete();
                break;
            }
            case OTHER: {
                this.incrementOther();
            }
        }
    }

    public void increment(StatementType statementType) {
        switch (statementType) {
            case STATEMENT: {
                this.incrementStatement();
                break;
            }
            case PREPARED: {
                this.incrementPrepared();
                break;
            }
            case CALLABLE: {
                this.incrementCallable();
            }
        }
    }

    public void incrementSelect() {
        this.select.incrementAndGet();
    }

    public void incrementInsert() {
        this.insert.incrementAndGet();
    }

    public void incrementUpdate() {
        this.update.incrementAndGet();
    }

    public void incrementDelete() {
        this.delete.incrementAndGet();
    }

    public void incrementOther() {
        this.other.incrementAndGet();
    }

    public void incrementStatement() {
        this.statement.incrementAndGet();
    }

    public void incrementPrepared() {
        this.prepared.incrementAndGet();
    }

    public void incrementCallable() {
        this.callable.incrementAndGet();
    }

    public void incrementTotal() {
        this.total.incrementAndGet();
    }

    public void incrementSuccess() {
        this.success.incrementAndGet();
    }

    public void incrementFailure() {
        this.failure.incrementAndGet();
    }

    public void incrementTime(long delta) {
        this.time.addAndGet(delta);
    }

    public long getSelect() {
        return this.select.longValue();
    }

    public void setSelect(long select) {
        this.select.set(select);
    }

    public long getInsert() {
        return this.insert.longValue();
    }

    public void setInsert(long insert) {
        this.insert.set(insert);
    }

    public long getUpdate() {
        return this.update.longValue();
    }

    public void setUpdate(long update) {
        this.update.set(update);
    }

    public long getDelete() {
        return this.delete.longValue();
    }

    public void setDelete(long delete) {
        this.delete.set(delete);
    }

    public long getOther() {
        return this.other.longValue();
    }

    public void setOther(long other) {
        this.other.set(other);
    }

    public long getStatement() {
        return this.statement.longValue();
    }

    public void setStatement(long statement) {
        this.statement.set(statement);
    }

    public long getPrepared() {
        return this.prepared.longValue();
    }

    public void setPrepared(long prepared) {
        this.prepared.set(prepared);
    }

    public long getCallable() {
        return this.callable.longValue();
    }

    public void setCallable(long callable) {
        this.callable.set(callable);
    }

    public long getTotal() {
        return this.total.longValue();
    }

    public void setTotal(long total) {
        this.total.set(total);
    }

    public long getSuccess() {
        return this.success.longValue();
    }

    public void setSuccess(long success) {
        this.success.set(success);
    }

    public long getFailure() {
        return this.failure.longValue();
    }

    public void setFailure(long failure) {
        this.failure.set(failure);
    }

    public long getTime() {
        return this.time.longValue();
    }

    public void setTime(long time) {
        this.time.set(time);
    }
}

