/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.boot.autoconfigure;

import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="jdbc")
public class JdbcProperties {
    private Set<TraceType> includes = Set.of(TraceType.CONNECTION, TraceType.QUERY, TraceType.FETCH);
    private Set<String> excludedDataSourceBeanNames = new HashSet<String>();
    private DataSourceProxy datasourceProxy = new DataSourceProxy();

    public Set<TraceType> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<TraceType> includes) {
        this.includes = includes;
    }

    public Set<String> getExcludedDataSourceBeanNames() {
        return this.excludedDataSourceBeanNames;
    }

    public void setExcludedDataSourceBeanNames(Set<String> excludedDataSourceBeanNames) {
        this.excludedDataSourceBeanNames = excludedDataSourceBeanNames;
    }

    public DataSourceProxy getDatasourceProxy() {
        return this.datasourceProxy;
    }

    public void setDatasourceProxy(DataSourceProxy datasourceProxy) {
        this.datasourceProxy = datasourceProxy;
    }

    public static enum TraceType {
        CONNECTION,
        QUERY,
        FETCH;

    }

    public static class DataSourceProxy {
        private Logging logging = Logging.SLF4J;
        private Query query = new Query();
        private SlowQuery slowQuery = new SlowQuery();
        private boolean multiline = true;
        private boolean includeParameterValues;
        private boolean jsonFormat = false;

        public Logging getLogging() {
            return this.logging;
        }

        public void setLogging(Logging logging) {
            this.logging = logging;
        }

        public Query getQuery() {
            return this.query;
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public SlowQuery getSlowQuery() {
            return this.slowQuery;
        }

        public void setSlowQuery(SlowQuery slowQuery) {
            this.slowQuery = slowQuery;
        }

        public boolean isMultiline() {
            return this.multiline;
        }

        public void setMultiline(boolean multiline) {
            this.multiline = multiline;
        }

        public boolean isJsonFormat() {
            return this.jsonFormat;
        }

        public void setJsonFormat(boolean jsonFormat) {
            this.jsonFormat = jsonFormat;
        }

        public boolean isIncludeParameterValues() {
            return this.includeParameterValues;
        }

        public void setIncludeParameterValues(boolean includeParameterValues) {
            this.includeParameterValues = includeParameterValues;
        }
    }

    public static enum Logging {
        SYSOUT,
        SLF4J,
        COMMONS,
        JUL,
        LOG4J;

    }

    public static class SlowQuery {
        private boolean enableLogging = false;
        private String loggerName;
        private String logLevel = "WARN";
        private long threshold = 300L;

        public boolean isEnableLogging() {
            return this.enableLogging;
        }

        public void setEnableLogging(boolean enableLogging) {
            this.enableLogging = enableLogging;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public long getThreshold() {
            return this.threshold;
        }

        public void setThreshold(long threshold) {
            this.threshold = threshold;
        }
    }

    public static class Query {
        private boolean enableLogging = false;
        private String loggerName;
        private String logLevel = "DEBUG";

        public boolean isEnableLogging() {
            return this.enableLogging;
        }

        public void setEnableLogging(boolean enableLogging) {
            this.enableLogging = enableLogging;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }
    }
}

