/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.boot.autoconfigure;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.ttddyy.dsproxy.ConnectionIdManager;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.logging.CommonsLogLevel;
import net.ttddyy.dsproxy.listener.logging.Log4jLogLevel;
import net.ttddyy.dsproxy.listener.logging.SLF4JLogLevel;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogicFactory;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import net.ttddyy.observation.boot.autoconfigure.DataSourceProxyConnectionIdManagerProvider;
import net.ttddyy.observation.boot.autoconfigure.JdbcProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;

public class DataSourceProxyBuilderConfigurer {
    private static final Log log = LogFactory.getLog(DataSourceProxyBuilderConfigurer.class);
    private final List<QueryExecutionListener> listeners;
    private final List<MethodExecutionListener> methodExecutionListeners;
    private final ParameterTransformer parameterTransformer;
    private final QueryTransformer queryTransformer;
    private final ResultSetProxyLogicFactory resultSetProxyLogicFactory;
    private final DataSourceProxyConnectionIdManagerProvider dataSourceProxyConnectionIdManagerProvider;
    private final JdbcProperties jdbcProperties;

    public DataSourceProxyBuilderConfigurer(JdbcProperties jdbcProperties, List<QueryExecutionListener> listeners, List<MethodExecutionListener> methodExecutionListeners, @Nullable ParameterTransformer parameterTransformer, @Nullable QueryTransformer queryTransformer, @Nullable ResultSetProxyLogicFactory resultSetProxyLogicFactory, @Nullable DataSourceProxyConnectionIdManagerProvider dataSourceProxyConnectionIdManagerProvider) {
        this.jdbcProperties = jdbcProperties;
        this.listeners = listeners;
        this.methodExecutionListeners = methodExecutionListeners;
        this.parameterTransformer = parameterTransformer;
        this.queryTransformer = queryTransformer;
        this.resultSetProxyLogicFactory = resultSetProxyLogicFactory;
        this.dataSourceProxyConnectionIdManagerProvider = dataSourceProxyConnectionIdManagerProvider;
    }

    public ProxyDataSourceBuilder configure(ProxyDataSourceBuilder proxyDataSourceBuilder) {
        JdbcProperties.DataSourceProxy datasourceProxy = this.jdbcProperties.getDatasourceProxy();
        switch (datasourceProxy.getLogging()) {
            case SLF4J: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryBySlf4j(this.toSlf4JLogLevel(datasourceProxy.getQuery().getLogLevel()), datasourceProxy.getQuery().getLoggerName());
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryBySlf4j(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS, this.toSlf4JLogLevel(datasourceProxy.getSlowQuery().getLogLevel()), datasourceProxy.getSlowQuery().getLoggerName());
                break;
            }
            case LOG4J: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryByLog4j(this.toLog4jLevel(datasourceProxy.getQuery().getLogLevel()), datasourceProxy.getQuery().getLoggerName());
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryByLog4j(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS, this.toLog4jLevel(datasourceProxy.getSlowQuery().getLogLevel()), datasourceProxy.getSlowQuery().getLoggerName());
                break;
            }
            case JUL: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryByJUL(this.toJULLogLevel(datasourceProxy.getQuery().getLogLevel()), datasourceProxy.getQuery().getLoggerName());
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryByJUL(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS, this.toJULLogLevel(datasourceProxy.getSlowQuery().getLogLevel()), datasourceProxy.getSlowQuery().getLoggerName());
                break;
            }
            case COMMONS: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryByCommons(this.toCommonsLogLevel(datasourceProxy.getQuery().getLogLevel()), datasourceProxy.getQuery().getLoggerName());
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryByCommons(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS, this.toCommonsLogLevel(datasourceProxy.getSlowQuery().getLogLevel()), datasourceProxy.getSlowQuery().getLoggerName());
                break;
            }
            case SYSOUT: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryToSysOut();
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryToSysOut(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS);
            }
        }
        if (datasourceProxy.isMultiline() && datasourceProxy.isJsonFormat()) {
            log.warn((Object)"Found opposite multiline and json format, multiline will be used (may depend on library version)");
        }
        if (datasourceProxy.isMultiline()) {
            proxyDataSourceBuilder.multiline();
        }
        if (datasourceProxy.isJsonFormat()) {
            proxyDataSourceBuilder.asJson();
        }
        if (this.jdbcProperties.getIncludes().contains((Object)JdbcProperties.TraceType.FETCH)) {
            ResultSetProxyLogicFactory factory = this.resultSetProxyLogicFactory == null ? ResultSetProxyLogicFactory.DEFAULT : this.resultSetProxyLogicFactory;
            proxyDataSourceBuilder.proxyResultSet(factory);
        }
        this.ifAvailable(this.listeners, l -> l.forEach(arg_0 -> ((ProxyDataSourceBuilder)proxyDataSourceBuilder).listener(arg_0)));
        this.ifAvailable(this.methodExecutionListeners, m -> m.forEach(arg_0 -> ((ProxyDataSourceBuilder)proxyDataSourceBuilder).methodListener(arg_0)));
        this.ifAvailable(this.parameterTransformer, arg_0 -> ((ProxyDataSourceBuilder)proxyDataSourceBuilder).parameterTransformer(arg_0));
        this.ifAvailable(this.queryTransformer, arg_0 -> ((ProxyDataSourceBuilder)proxyDataSourceBuilder).queryTransformer(arg_0));
        this.ifAvailable(this.dataSourceProxyConnectionIdManagerProvider, d -> proxyDataSourceBuilder.connectionIdManager((ConnectionIdManager)d.get()));
        return proxyDataSourceBuilder;
    }

    private <T> void ifAvailable(@Nullable T o, Consumer<T> consumer) {
        if (o != null) {
            consumer.accept(o);
        }
    }

    private SLF4JLogLevel toSlf4JLogLevel(String logLevel) {
        for (SLF4JLogLevel slf4JLogLevel : SLF4JLogLevel.values()) {
            if (!slf4JLogLevel.name().equalsIgnoreCase(logLevel)) continue;
            return slf4JLogLevel;
        }
        throw new IllegalArgumentException("Unresolved log level " + logLevel + " for slf4j logger, known levels: " + Arrays.toString(SLF4JLogLevel.values()));
    }

    private Level toJULLogLevel(String logLevel) {
        try {
            return Level.parse(logLevel);
        }
        catch (IllegalArgumentException e) {
            if (logLevel.equalsIgnoreCase("DEBUG")) {
                return Level.FINE;
            }
            if (logLevel.equalsIgnoreCase("WARN")) {
                return Level.WARNING;
            }
            throw new IllegalArgumentException("Unresolved log level " + logLevel + " for java.util.logging", e);
        }
    }

    private CommonsLogLevel toCommonsLogLevel(String logLevel) {
        for (CommonsLogLevel commonsLogLevel : CommonsLogLevel.values()) {
            if (!commonsLogLevel.name().equalsIgnoreCase(logLevel)) continue;
            return commonsLogLevel;
        }
        throw new IllegalArgumentException("Unresolved log level " + logLevel + " for apache commons logger, known levels " + Arrays.toString(CommonsLogLevel.values()));
    }

    private Log4jLogLevel toLog4jLevel(String logLevel) {
        for (Log4jLogLevel log4jLogLevel : Log4jLogLevel.values()) {
            if (!log4jLogLevel.name().equalsIgnoreCase(logLevel)) continue;
            return log4jLogLevel;
        }
        throw new IllegalArgumentException("Unresolved log level " + logLevel + " for apache log4j logger, known levels " + Arrays.toString(Log4jLogLevel.values()));
    }
}

