/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.tracing;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionContext;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.observation.tracing.ConnectionAttributesManager;
import net.ttddyy.observation.tracing.ConnectionContext;
import net.ttddyy.observation.tracing.ConnectionObservationConvention;
import net.ttddyy.observation.tracing.DataSourceBaseContext;
import net.ttddyy.observation.tracing.DefaultConnectionAttributesManager;
import net.ttddyy.observation.tracing.DefaultQueryParametersSpanTagProvider;
import net.ttddyy.observation.tracing.JdbcObservation;
import net.ttddyy.observation.tracing.QueryContext;
import net.ttddyy.observation.tracing.QueryObservationConvention;
import net.ttddyy.observation.tracing.QueryParametersSpanTagProvider;
import net.ttddyy.observation.tracing.ResultSetContext;
import net.ttddyy.observation.tracing.ResultSetObservationConvention;

public class DataSourceObservationListener
implements QueryExecutionListener,
MethodExecutionListener {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DataSourceObservationListener.class);
    private final Supplier<ObservationRegistry> observationRegistrySupplier;
    private ConnectionAttributesManager connectionAttributesManager = new DefaultConnectionAttributesManager();
    private ConnectionObservationConvention connectionObservationConvention = new ConnectionObservationConvention(){};
    private QueryObservationConvention queryObservationConvention = new QueryObservationConvention(){};
    private ResultSetObservationConvention resultSetObservationConvention = new ResultSetObservationConvention(){};
    private QueryParametersSpanTagProvider queryParametersSpanTagProvider = new DefaultQueryParametersSpanTagProvider();
    private boolean includeParameterValues;

    public DataSourceObservationListener(ObservationRegistry observationRegistry) {
        this(() -> observationRegistry);
    }

    public DataSourceObservationListener(Supplier<ObservationRegistry> observationRegistry) {
        this.observationRegistrySupplier = observationRegistry;
    }

    public void beforeQuery(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList) {
        this.startQueryObservation(executionInfo, queryInfoList);
    }

    public void afterQuery(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList) {
        this.stopQueryObservation(executionInfo);
    }

    private void startQueryObservation(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList) {
        QueryContext queryContext = new QueryContext();
        executionInfo.addCustomValue(QueryContext.class.getName(), (Object)queryContext);
        this.populateFromConnectionAttributes(queryContext, executionInfo.getConnectionId());
        Observation observation = this.createAndStartObservation(JdbcObservation.QUERY, queryContext, this.queryObservationConvention);
        if (logger.isDebugEnabled()) {
            logger.debug("Created a new child observation before query [" + observation + "]");
        }
        this.populateQueryContext(executionInfo, queryInfoList, queryContext);
        executionInfo.addCustomValue(Observation.Scope.class.getName(), (Object)observation.openScope());
    }

    private Observation createAndStartObservation(JdbcObservation observationType, DataSourceBaseContext context, ObservationConvention<? extends Observation.Context> observationConvention) {
        return observationType.observation(this.observationRegistrySupplier.get(), (Observation.Context)context).observationConvention(observationConvention).start();
    }

    private void populateQueryContext(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList, QueryContext context) {
        for (QueryInfo queryInfo : queryInfoList) {
            context.getQueries().add(queryInfo.getQuery());
            if (!this.includeParameterValues) continue;
            String params = this.queryParametersSpanTagProvider.getParameters(executionInfo, queryInfoList);
            context.getParams().add(params);
        }
    }

    private void populateFromConnectionAttributes(DataSourceBaseContext context, String connectionId) {
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes != null) {
            context.setHost(connectionAttributes.host);
            context.setPort(connectionAttributes.port);
            context.setRemoteServiceName(connectionAttributes.connectionInfo.getDataSourceName());
            context.setDataSource(connectionAttributes.dataSource);
        }
    }

    private void stopQueryObservation(ExecutionInfo executionInfo) {
        String methodName = executionInfo.getMethod().getName();
        boolean hasAffectedRowCount = executionInfo.getThrowable() == null && ("executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName) || "executeBatch".equals(methodName) || "executeLargeBatch".equals(methodName));
        Observation.Scope scopeToUse = (Observation.Scope)executionInfo.getCustomValue(Observation.Scope.class.getName(), Observation.Scope.class);
        if (scopeToUse == null) {
            return;
        }
        try (Observation.Scope scope = scopeToUse;){
            Observation observation = scope.getCurrentObservation();
            if (logger.isDebugEnabled()) {
                logger.debug("Continued the child observation in after query [" + observation + "]");
            }
            if (hasAffectedRowCount) {
                Object result = executionInfo.getResult();
                String affectedRowCount = "executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName) ? String.valueOf(result) : ("executeBatch".equals(methodName) ? Arrays.toString((int[])result) : Arrays.toString((long[])result));
                QueryContext queryContext = (QueryContext)((Object)executionInfo.getCustomValue(QueryContext.class.getName(), QueryContext.class));
                queryContext.setAffectedRowCount(affectedRowCount);
            }
            this.stopObservation(observation, executionInfo.getThrowable());
        }
    }

    public void beforeMethod(MethodExecutionContext executionContext) {
        String methodName = executionContext.getMethod().getName();
        Object target = executionContext.getTarget();
        if (target instanceof DataSource && "getConnection".equals(methodName)) {
            this.handleGetConnectionBefore(executionContext);
        }
    }

    public void afterMethod(MethodExecutionContext executionContext) {
        String methodName = executionContext.getMethod().getName();
        Object target = executionContext.getTarget();
        if (target instanceof DataSource && "getConnection".equals(methodName)) {
            this.handleGetConnectionAfter(executionContext);
        } else if (target instanceof Connection) {
            if ("close".equals(methodName)) {
                this.handleConnectionClose(executionContext);
            } else if ("commit".equals(methodName)) {
                this.handleConnectionCommit(executionContext);
            } else if ("rollback".equals(methodName)) {
                this.handleConnectionRollback(executionContext);
            }
        } else if (target instanceof Statement) {
            if ("close".equals(methodName)) {
                this.handleStatementClose(executionContext);
            }
        } else if (target instanceof ResultSet) {
            if ("close".equals(methodName)) {
                this.handleResultSetClose(executionContext);
            } else if ("next".equals(methodName)) {
                this.handleResultSetNext(executionContext);
            }
        }
    }

    private void handleGetConnectionBefore(MethodExecutionContext executionContext) {
        ConnectionContext connectionContext = new ConnectionContext();
        executionContext.addCustomValue(ConnectionContext.class.getName(), (Object)connectionContext);
        Observation observation = this.createAndStartObservation(JdbcObservation.CONNECTION, connectionContext, this.connectionObservationConvention);
        executionContext.addCustomValue(Observation.Scope.class.getName(), (Object)observation.openScope());
    }

    private void handleGetConnectionAfter(MethodExecutionContext executionContext) {
        DataSource dataSource = (DataSource)executionContext.getTarget();
        Connection connection = (Connection)executionContext.getResult();
        URI connectionUrl = this.getConnectionUrl(connection);
        Observation.Scope scopeToUse = (Observation.Scope)executionContext.getCustomValue(Observation.Scope.class.getName(), Observation.Scope.class);
        ConnectionInfo connectionInfo = executionContext.getConnectionInfo();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = new ConnectionAttributesManager.ConnectionAttributes();
        connectionAttributes.connectionInfo = connectionInfo;
        connectionAttributes.scope = scopeToUse;
        connectionAttributes.dataSource = dataSource;
        if (connectionUrl != null) {
            connectionAttributes.host = connectionUrl.getHost();
            connectionAttributes.port = connectionUrl.getPort();
        }
        String connectionId = connectionInfo.getConnectionId();
        this.connectionAttributesManager.put(connectionId, connectionAttributes);
        ConnectionContext connectionContext = (ConnectionContext)((Object)executionContext.getCustomValue(ConnectionContext.class.getName(), ConnectionContext.class));
        this.populateFromConnectionAttributes(connectionContext, connectionId);
        Throwable throwable = executionContext.getThrown();
        if (throwable != null && scopeToUse != null) {
            try (Observation.Scope scope = scopeToUse;){
                this.connectionAttributesManager.remove(connectionId);
                this.stopObservation(scope.getCurrentObservation(), throwable);
            }
        }
        if (scopeToUse != null) {
            scopeToUse.getCurrentObservation().event((Observation.Event)JdbcObservation.JdbcEvents.CONNECTION_ACQUIRED);
        }
    }

    private void handleConnectionClose(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.remove(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Set<ConnectionAttributesManager.ResultSetAttributes> resultSetAttributes = connectionAttributes.resultSetAttributesManager.removeAll();
        for (ConnectionAttributesManager.ResultSetAttributes resultSetAttribute : resultSetAttributes) {
            this.stopResultSetObservation(resultSetAttribute.scope, executionContext.getThrown());
        }
        Observation.Scope scopeToUse = connectionAttributes.scope;
        if (scopeToUse == null) {
            return;
        }
        try (Observation.Scope scope = scopeToUse;){
            this.stopObservation(scope.getCurrentObservation(), executionContext.getThrown());
        }
    }

    private void stopObservation(Observation observation, @Nullable Throwable throwable) {
        if (throwable != null) {
            observation.error(throwable);
        }
        observation.stop();
    }

    private void handleConnectionCommit(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Observation.Scope scopeToUse = connectionAttributes.scope;
        if (scopeToUse == null) {
            return;
        }
        scopeToUse.getCurrentObservation().event((Observation.Event)JdbcObservation.JdbcEvents.CONNECTION_COMMIT);
    }

    private void handleConnectionRollback(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Observation.Scope scopeToUse = connectionAttributes.scope;
        if (scopeToUse == null) {
            return;
        }
        scopeToUse.getCurrentObservation().event((Observation.Event)JdbcObservation.JdbcEvents.CONNECTION_ROLLBACK);
    }

    private void handleResultSetNext(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Boolean hasNext = (Boolean)executionContext.getResult();
        ResultSet resultSet = (ResultSet)executionContext.getTarget();
        if (hasNext.booleanValue()) {
            ConnectionAttributesManager.ResultSetAttributes resultSetAttributes = connectionAttributes.resultSetAttributesManager.getByResultSet(resultSet);
            if (resultSetAttributes == null) {
                ResultSetContext resultSetContext = new ResultSetContext();
                this.populateFromConnectionAttributes(resultSetContext, executionContext.getConnectionInfo().getConnectionId());
                Observation observation = this.createAndStartObservation(JdbcObservation.RESULT_SET, resultSetContext, this.resultSetObservationConvention);
                if (logger.isDebugEnabled()) {
                    logger.debug("Created a new result-set observation [" + observation + "]");
                }
                resultSetAttributes = new ConnectionAttributesManager.ResultSetAttributes();
                resultSetAttributes.scope = observation.openScope();
                resultSetAttributes.context = resultSetContext;
                Statement statement = null;
                try {
                    statement = resultSet.getStatement();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                connectionAttributes.resultSetAttributesManager.add(resultSet, statement, resultSetAttributes);
            }
            resultSetAttributes.context.incrementCount();
        }
    }

    @Nullable
    private URI getConnectionUrl(Connection connection) {
        URI url = null;
        try {
            String urlAsString = connection.getMetaData().getURL().substring(5);
            url = URI.create(urlAsString.replace(" ", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private void handleStatementClose(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Statement statement = (Statement)executionContext.getTarget();
        Set<ConnectionAttributesManager.ResultSetAttributes> resultSetAttributes = connectionAttributes.resultSetAttributesManager.removeByStatement(statement);
        for (ConnectionAttributesManager.ResultSetAttributes resultSetAttribute : resultSetAttributes) {
            this.stopResultSetObservation(resultSetAttribute.scope, executionContext.getThrown());
        }
    }

    private void handleResultSetClose(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        ResultSet resultSet = (ResultSet)executionContext.getTarget();
        ConnectionAttributesManager.ResultSetAttributes resultSetAttributes = connectionAttributes.resultSetAttributesManager.removeByResultSet(resultSet);
        if (resultSetAttributes == null) {
            return;
        }
        this.stopResultSetObservation(resultSetAttributes.scope, executionContext.getThrown());
    }

    private void stopResultSetObservation(@Nullable Observation.Scope scopeToUse, @Nullable Throwable throwable) {
        if (scopeToUse == null) {
            return;
        }
        try (Observation.Scope scope = scopeToUse;){
            this.stopObservation(scope.getCurrentObservation(), throwable);
        }
    }

    public void setConnectionAttributesManager(ConnectionAttributesManager connectionAttributesManager) {
        this.connectionAttributesManager = connectionAttributesManager;
    }

    public void setConnectionObservationConvention(ConnectionObservationConvention connectionObservationConvention) {
        this.connectionObservationConvention = connectionObservationConvention;
    }

    public void setQueryObservationConvention(QueryObservationConvention queryObservationConvention) {
        this.queryObservationConvention = queryObservationConvention;
    }

    public void setResultSetObservationConvention(ResultSetObservationConvention resultSetObservationConvention) {
        this.resultSetObservationConvention = resultSetObservationConvention;
    }

    public void setQueryParametersSpanTagProvider(QueryParametersSpanTagProvider queryParametersSpanTagProvider) {
        this.queryParametersSpanTagProvider = queryParametersSpanTagProvider;
    }

    public void setIncludeParameterValues(boolean includeParameterValues) {
        this.includeParameterValues = includeParameterValues;
    }
}

