/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.tracing;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import java.util.HashSet;
import net.ttddyy.observation.tracing.JdbcObservation;
import net.ttddyy.observation.tracing.QueryContext;

public interface QueryObservationConvention
extends ObservationConvention<QueryContext> {
    default public boolean supportsContext(Observation.Context context) {
        return context instanceof QueryContext;
    }

    default public String getName() {
        return "jdbc.query";
    }

    default public KeyValues getHighCardinalityKeyValues(QueryContext context) {
        int i;
        HashSet<KeyValue> keyValues = new HashSet<KeyValue>();
        for (i = 0; i < context.getQueries().size(); ++i) {
            String key = context.getQueries().get(i);
            String queryKey = String.format(JdbcObservation.QueryHighCardinalityKeyNames.QUERY.asString(), i);
            keyValues.add(KeyValue.of((String)queryKey, (String)key));
        }
        for (i = 0; i < context.getParams().size(); ++i) {
            String params = context.getParams().get(i);
            String key = String.format(JdbcObservation.QueryHighCardinalityKeyNames.QUERY_PARAMETERS.asString(), i);
            keyValues.add(KeyValue.of((String)key, (String)params));
        }
        String affectedRowCount = context.getAffectedRowCount();
        if (affectedRowCount != null) {
            keyValues.add(KeyValue.of((KeyName)JdbcObservation.QueryHighCardinalityKeyNames.ROW_AFFECTED, (String)affectedRowCount));
        }
        return KeyValues.of(keyValues);
    }
}

