/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.tracing;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionContext;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.ProxyJdbcObject;
import net.ttddyy.observation.tracing.ConnectionAttributesManager;
import net.ttddyy.observation.tracing.ConnectionContext;
import net.ttddyy.observation.tracing.ConnectionObservationConvention;
import net.ttddyy.observation.tracing.DataSourceBaseContext;
import net.ttddyy.observation.tracing.DefaultConnectionAttributesManager;
import net.ttddyy.observation.tracing.DefaultQueryParametersSpanTagProvider;
import net.ttddyy.observation.tracing.GeneratedKeysObservationConvention;
import net.ttddyy.observation.tracing.JdbcObservationDocumentation;
import net.ttddyy.observation.tracing.QueryContext;
import net.ttddyy.observation.tracing.QueryObservationConvention;
import net.ttddyy.observation.tracing.QueryParametersSpanTagProvider;
import net.ttddyy.observation.tracing.ResultSetContext;
import net.ttddyy.observation.tracing.ResultSetObservationConvention;
import net.ttddyy.observation.tracing.ResultSetOperation;

public class DataSourceObservationListener
implements QueryExecutionListener,
MethodExecutionListener {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DataSourceObservationListener.class);
    private static final Set<String> METHODS_TO_IGNORE = new HashSet<String>(Arrays.asList("toString", "equals", "hashCode", "unwrap", "isWrapperFor", "getTarget", "getProxyConfig", "getDataSourceName"));
    private final Supplier<ObservationRegistry> observationRegistrySupplier;
    private ConnectionAttributesManager connectionAttributesManager = new DefaultConnectionAttributesManager();
    private ConnectionObservationConvention connectionObservationConvention = new ConnectionObservationConvention(){};
    private QueryObservationConvention queryObservationConvention = new QueryObservationConvention(){};
    private ResultSetObservationConvention resultSetObservationConvention = new ResultSetObservationConvention(){};
    private GeneratedKeysObservationConvention generatedKeysObservationConvention = new GeneratedKeysObservationConvention(){};
    private QueryParametersSpanTagProvider queryParametersSpanTagProvider = new DefaultQueryParametersSpanTagProvider();
    private boolean includeParameterValues;
    private Set<JdbcObservationDocumentation> supportedTypes = new HashSet<JdbcObservationDocumentation>(Arrays.asList(JdbcObservationDocumentation.values()));

    public DataSourceObservationListener(ObservationRegistry observationRegistry) {
        this(() -> observationRegistry);
    }

    public DataSourceObservationListener(Supplier<ObservationRegistry> observationRegistry) {
        this.observationRegistrySupplier = observationRegistry;
    }

    public void beforeQuery(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList) {
        this.startQueryObservation(executionInfo, queryInfoList);
    }

    public void afterQuery(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList) {
        this.stopQueryObservation(executionInfo);
    }

    private void startQueryObservation(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList) {
        QueryContext queryContext = new QueryContext();
        executionInfo.addCustomValue(QueryContext.class.getName(), (Object)queryContext);
        this.populateFromConnectionAttributes(queryContext, executionInfo.getConnectionId());
        this.populateQueryContext(executionInfo, queryInfoList, queryContext);
        Observation observation = this.createAndStartObservation(JdbcObservationDocumentation.QUERY, queryContext, this.queryObservationConvention);
        if (logger.isDebugEnabled()) {
            logger.debug("Created a new child observation before query [" + observation + "]");
        }
        executionInfo.addCustomValue(Observation.Scope.class.getName(), (Object)observation.openScope());
    }

    private Observation createAndStartObservation(JdbcObservationDocumentation observationType, DataSourceBaseContext context, ObservationConvention<? extends Observation.Context> observationConvention) {
        if (this.supportedTypes.contains((Object)observationType)) {
            return observationType.observation(this.observationRegistrySupplier.get(), () -> context).observationConvention(observationConvention).start();
        }
        return Observation.NOOP;
    }

    private void populateQueryContext(ExecutionInfo executionInfo, List<QueryInfo> queryInfoList, QueryContext context) {
        for (QueryInfo queryInfo : queryInfoList) {
            context.getQueries().add(queryInfo.getQuery());
            if (!this.includeParameterValues) continue;
            String params = this.queryParametersSpanTagProvider.getParameters(executionInfo, queryInfoList);
            context.getParams().add(params);
        }
        context.setDataSourceName(executionInfo.getDataSourceName());
    }

    private void populateFromConnectionAttributes(DataSourceBaseContext context, String connectionId) {
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes != null) {
            String dataSourceName = connectionAttributes.connectionInfo.getDataSourceName();
            context.setHost(connectionAttributes.host);
            context.setPort(connectionAttributes.port);
            context.setRemoteServiceName(dataSourceName);
            context.setDataSourceName(dataSourceName);
            context.setDataSource(connectionAttributes.dataSource);
        }
    }

    private void stopQueryObservation(ExecutionInfo executionInfo) {
        String methodName = executionInfo.getMethod().getName();
        boolean hasAffectedRowCount = executionInfo.getThrowable() == null && ("executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName) || "executeBatch".equals(methodName) || "executeLargeBatch".equals(methodName));
        Observation.Scope scopeToUse = (Observation.Scope)executionInfo.getCustomValue(Observation.Scope.class.getName(), Observation.Scope.class);
        if (scopeToUse == null) {
            return;
        }
        try (Observation.Scope scope = scopeToUse;){
            Observation observation = scope.getCurrentObservation();
            if (logger.isDebugEnabled()) {
                logger.debug("Continued the child observation in after query [" + observation + "]");
            }
            if (hasAffectedRowCount) {
                Object result = executionInfo.getResult();
                String affectedRowCount = "executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName) ? String.valueOf(result) : ("executeBatch".equals(methodName) ? Arrays.toString((int[])result) : Arrays.toString((long[])result));
                QueryContext queryContext = (QueryContext)((Object)executionInfo.getCustomValue(QueryContext.class.getName(), QueryContext.class));
                queryContext.setAffectedRowCount(affectedRowCount);
            }
            this.stopObservation(observation, executionInfo.getThrowable());
        }
    }

    public void beforeMethod(MethodExecutionContext executionContext) {
        String methodName = executionContext.getMethod().getName();
        if (METHODS_TO_IGNORE.contains(methodName)) {
            return;
        }
        Object target = executionContext.getTarget();
        if (target instanceof DataSource && "getConnection".equals(methodName)) {
            this.handleGetConnectionBefore(executionContext);
        }
    }

    public void afterMethod(MethodExecutionContext executionContext) {
        String methodName = executionContext.getMethod().getName();
        if (METHODS_TO_IGNORE.contains(methodName)) {
            return;
        }
        Object target = executionContext.getTarget();
        if (target instanceof DataSource && "getConnection".equals(methodName)) {
            this.handleGetConnectionAfter(executionContext);
        } else if (target instanceof Connection) {
            if ("close".equals(methodName)) {
                this.handleConnectionClose(executionContext);
            } else if ("commit".equals(methodName)) {
                this.handleConnectionCommit(executionContext);
            } else if ("rollback".equals(methodName)) {
                this.handleConnectionRollback(executionContext);
            }
        } else if (target instanceof Statement) {
            String connectionId;
            ConnectionAttributesManager.ConnectionAttributes connectionAttributes;
            if ("close".equals(methodName)) {
                this.handleStatementClose(executionContext);
            } else if ("getGeneratedKeys".equals(methodName) && executionContext.getResult() instanceof ResultSet && (connectionAttributes = this.connectionAttributesManager.get(connectionId = executionContext.getConnectionInfo().getConnectionId())) != null) {
                ResultSet resultSet = (ResultSet)executionContext.getResult();
                if (resultSet instanceof ProxyJdbcObject) {
                    resultSet = (ResultSet)((ProxyJdbcObject)resultSet).getTarget();
                }
                connectionAttributes.resultSetAttributesManager.addGeneratedKeys(resultSet);
            }
        } else if (target instanceof ResultSet) {
            this.handleResultSet(executionContext);
        }
    }

    private void handleGetConnectionBefore(MethodExecutionContext executionContext) {
        ConnectionContext connectionContext = new ConnectionContext();
        connectionContext.setDataSourceName(executionContext.getProxyConfig().getDataSourceName());
        executionContext.addCustomValue(ConnectionContext.class.getName(), (Object)connectionContext);
        Observation observation = this.createAndStartObservation(JdbcObservationDocumentation.CONNECTION, connectionContext, this.connectionObservationConvention);
        executionContext.addCustomValue(Observation.Scope.class.getName(), (Object)observation.openScope());
    }

    private void handleGetConnectionAfter(MethodExecutionContext executionContext) {
        DataSource dataSource = (DataSource)executionContext.getTarget();
        Connection connection = (Connection)executionContext.getResult();
        Observation.Scope scopeToUse = (Observation.Scope)executionContext.getCustomValue(Observation.Scope.class.getName(), Observation.Scope.class);
        ConnectionContext connectionContext = (ConnectionContext)((Object)executionContext.getCustomValue(ConnectionContext.class.getName(), ConnectionContext.class));
        if (connection == null) {
            connectionContext.setDataSource(dataSource);
            if (scopeToUse != null) {
                Throwable throwable = executionContext.getThrown();
                try (Observation.Scope scope = scopeToUse;){
                    this.stopObservation(scope.getCurrentObservation(), throwable);
                }
            }
        } else {
            ConnectionInfo connectionInfo = executionContext.getConnectionInfo();
            ConnectionAttributesManager.ConnectionAttributes connectionAttributes = new ConnectionAttributesManager.ConnectionAttributes();
            connectionAttributes.connectionInfo = connectionInfo;
            connectionAttributes.scope = scopeToUse;
            connectionAttributes.dataSource = dataSource;
            URI connectionUrl = this.getConnectionUrl(connection);
            if (connectionUrl != null) {
                connectionAttributes.host = connectionUrl.getHost();
                connectionAttributes.port = connectionUrl.getPort();
            }
            String connectionId = connectionInfo.getConnectionId();
            this.connectionAttributesManager.put(connectionId, connectionAttributes);
            this.populateFromConnectionAttributes(connectionContext, connectionId);
            if (scopeToUse != null) {
                scopeToUse.getCurrentObservation().event((Observation.Event)JdbcObservationDocumentation.JdbcEvents.CONNECTION_ACQUIRED);
            }
        }
    }

    private void handleConnectionClose(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.remove(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Set<ConnectionAttributesManager.ResultSetAttributes> resultSetAttributes = connectionAttributes.resultSetAttributesManager.removeAll();
        for (ConnectionAttributesManager.ResultSetAttributes resultSetAttribute : resultSetAttributes) {
            this.stopResultSetObservation(resultSetAttribute.scope, executionContext.getThrown());
        }
        Observation.Scope scopeToUse = connectionAttributes.scope;
        if (scopeToUse == null) {
            return;
        }
        try (Observation.Scope scope = scopeToUse;){
            this.stopObservation(scope.getCurrentObservation(), executionContext.getThrown());
        }
    }

    private void stopObservation(Observation observation, @Nullable Throwable throwable) {
        if (throwable != null) {
            observation.error(throwable);
        }
        observation.stop();
    }

    private void handleConnectionCommit(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Observation.Scope scopeToUse = connectionAttributes.scope;
        if (scopeToUse == null) {
            return;
        }
        scopeToUse.getCurrentObservation().event((Observation.Event)JdbcObservationDocumentation.JdbcEvents.CONNECTION_COMMIT);
    }

    private void handleConnectionRollback(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Observation.Scope scopeToUse = connectionAttributes.scope;
        if (scopeToUse == null) {
            return;
        }
        scopeToUse.getCurrentObservation().event((Observation.Event)JdbcObservationDocumentation.JdbcEvents.CONNECTION_ROLLBACK);
    }

    private void handleResultSet(MethodExecutionContext executionContext) {
        boolean hasNext;
        boolean createResultSetAttributes;
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        String methodName = executionContext.getMethod().getName();
        boolean isClose = "close".equals(methodName);
        ResultSet resultSet = (ResultSet)executionContext.getTarget();
        ConnectionAttributesManager.ResultSetAttributes resultSetAttributes = connectionAttributes.resultSetAttributesManager.getByResultSet(resultSet);
        boolean bl = createResultSetAttributes = resultSetAttributes == null && !isClose;
        if (createResultSetAttributes) {
            boolean isGeneratedKey = connectionAttributes.resultSetAttributesManager.isGeneratedKeys(resultSet);
            resultSetAttributes = this.createResultSetAttributesAndStartObservation(executionContext, isGeneratedKey);
            Statement statement = null;
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connectionAttributes.resultSetAttributesManager.add(resultSet, statement, resultSetAttributes);
        }
        if (resultSetAttributes != null) {
            ResultSetOperation operation = new ResultSetOperation(executionContext.getMethod(), executionContext.getMethodArgs(), executionContext.getResult(), executionContext.getThrown());
            resultSetAttributes.context.addOperation(operation);
        }
        if (isClose) {
            connectionAttributes.resultSetAttributesManager.removeByResultSet(resultSet);
            if (resultSetAttributes != null) {
                this.stopResultSetObservation(resultSetAttributes.scope, executionContext.getThrown());
            }
        } else if ("next".equals(methodName) && (hasNext = Boolean.TRUE.equals(executionContext.getResult()))) {
            resultSetAttributes.context.incrementCount();
        }
    }

    private ConnectionAttributesManager.ResultSetAttributes createResultSetAttributesAndStartObservation(MethodExecutionContext executionContext, boolean isGeneratedKeys) {
        ResultSetContext resultSetContext = new ResultSetContext();
        this.populateFromConnectionAttributes(resultSetContext, executionContext.getConnectionInfo().getConnectionId());
        Observation observation = isGeneratedKeys ? this.createAndStartObservation(JdbcObservationDocumentation.GENERATED_KEYS, resultSetContext, this.generatedKeysObservationConvention) : this.createAndStartObservation(JdbcObservationDocumentation.RESULT_SET, resultSetContext, this.resultSetObservationConvention);
        if (logger.isDebugEnabled()) {
            logger.debug("Created a new result-set observation [" + observation + "]");
        }
        ConnectionAttributesManager.ResultSetAttributes resultSetAttributes = new ConnectionAttributesManager.ResultSetAttributes();
        resultSetAttributes.scope = observation.openScope();
        resultSetAttributes.context = resultSetContext;
        return resultSetAttributes;
    }

    @Nullable
    private URI getConnectionUrl(Connection connection) {
        URI url = null;
        try {
            String urlAsString = connection.getMetaData().getURL().substring(5);
            url = URI.create(urlAsString.replace(" ", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private void handleStatementClose(MethodExecutionContext executionContext) {
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        ConnectionAttributesManager.ConnectionAttributes connectionAttributes = this.connectionAttributesManager.get(connectionId);
        if (connectionAttributes == null) {
            return;
        }
        Statement statement = (Statement)executionContext.getTarget();
        Set<ConnectionAttributesManager.ResultSetAttributes> resultSetAttributes = connectionAttributes.resultSetAttributesManager.removeByStatement(statement);
        for (ConnectionAttributesManager.ResultSetAttributes resultSetAttribute : resultSetAttributes) {
            this.stopResultSetObservation(resultSetAttribute.scope, executionContext.getThrown());
        }
    }

    private void stopResultSetObservation(@Nullable Observation.Scope scopeToUse, @Nullable Throwable throwable) {
        if (scopeToUse == null) {
            return;
        }
        try (Observation.Scope scope = scopeToUse;){
            this.stopObservation(scope.getCurrentObservation(), throwable);
        }
    }

    public void setConnectionAttributesManager(ConnectionAttributesManager connectionAttributesManager) {
        this.connectionAttributesManager = connectionAttributesManager;
    }

    public void setConnectionObservationConvention(ConnectionObservationConvention connectionObservationConvention) {
        this.connectionObservationConvention = connectionObservationConvention;
    }

    public void setQueryObservationConvention(QueryObservationConvention queryObservationConvention) {
        this.queryObservationConvention = queryObservationConvention;
    }

    public void setResultSetObservationConvention(ResultSetObservationConvention resultSetObservationConvention) {
        this.resultSetObservationConvention = resultSetObservationConvention;
    }

    public void setGeneratedKeysObservationConvention(GeneratedKeysObservationConvention generatedKeysObservationConvention) {
        this.generatedKeysObservationConvention = generatedKeysObservationConvention;
    }

    public void setQueryParametersSpanTagProvider(QueryParametersSpanTagProvider queryParametersSpanTagProvider) {
        this.queryParametersSpanTagProvider = queryParametersSpanTagProvider;
    }

    public void setIncludeParameterValues(boolean includeParameterValues) {
        this.includeParameterValues = includeParameterValues;
    }

    public void setSupportedTypes(Set<JdbcObservationDocumentation> supportedTypes) {
        this.supportedTypes = supportedTypes;
    }
}

