/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.slideshare.api.impl;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.social.slideshare.api.SlideshowOperations;
import org.springframework.social.slideshare.api.domain.GetSlideshowsResponse;
import org.springframework.social.slideshare.api.domain.PrivacySetting;
import org.springframework.social.slideshare.api.domain.SearchOptions;
import org.springframework.social.slideshare.api.domain.SearchSlideshowsResponse;
import org.springframework.social.slideshare.api.domain.Slideshow;
import org.springframework.social.slideshare.api.impl.SlideShareException;
import org.springframework.social.slideshare.api.impl.xml.SlideshowIdHolder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

public class SlideshowTemplate
implements SlideshowOperations {
    public static final String BASE_URL = "https://www.slideshare.net/api/2";
    public static final String GET_SLIDESHOW_URL = "https://www.slideshare.net/api/2/get_slideshow";
    public static final String GET_SLIDESHOWS_BY_TAG_URL = "https://www.slideshare.net/api/2/get_slideshows_by_tag";
    public static final String GET_SLIDESHOWS_BY_GROUP_URL = "https://www.slideshare.net/api/2/get_slideshows_by_group";
    public static final String GET_SLIDESHOWS_BY_USER_URL = "https://www.slideshare.net/api/2/get_slideshows_by_user";
    public static final String SEARCH_SLIDESHOWS_URL = "https://www.slideshare.net/api/2/search_slideshows";
    public static final String EDIT_SLIDESHOW_URL = "https://www.slideshare.net/api/2/edit_slideshow";
    public static final String DELETE_SLIDESHOW_URL = "https://www.slideshare.net/api/2/delete_slideshow";
    public static final String UPLOAD_SLIDESHOW_URL = "https://www.slideshare.net/api/2/upload_slideshow";
    private final RestOperations restOperations;

    public SlideshowTemplate(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    @Override
    public Slideshow getSlideshowById(String slideshowId) {
        return this.getSlideshow(slideshowId, null, null, null, false, true, true);
    }

    @Override
    public Slideshow getSlideshowById(String slideshowId, String username, String password) {
        return this.getSlideshow(slideshowId, null, username, password, false, true, true);
    }

    @Override
    public Slideshow getSlideshowById(String slideshowId, String username, String password, boolean excludeTags, boolean detailed, boolean transcript) {
        return this.getSlideshow(slideshowId, null, username, password, excludeTags, detailed, transcript);
    }

    @Override
    public Slideshow getSlideshowByUrl(String slideshowUrl) {
        return this.getSlideshow(null, slideshowUrl, null, null, false, true, true);
    }

    @Override
    public Slideshow getSlideshowByUrl(String slideshowUrl, String username, String password) {
        return this.getSlideshow(null, slideshowUrl, username, password, false, true, true);
    }

    @Override
    public Slideshow getSlideshowByUrl(String slideshowUrl, String username, String password, boolean excludeTags, boolean detailed, boolean transcript) {
        return this.getSlideshow(null, slideshowUrl, username, password, excludeTags, detailed, transcript);
    }

    @Override
    public Slideshow getSlideshow(String slideshowId, String slideshowUrl) {
        return this.getSlideshow(slideshowId, slideshowUrl, null, null, false, true, true);
    }

    @Override
    public Slideshow getSlideshow(String slideshowId, String slideshowUrl, String username, String password) {
        return this.getSlideshow(slideshowId, slideshowUrl, username, password, false, true, true);
    }

    @Override
    public Slideshow getSlideshow(String slideshowId, String slideshowUrl, String username, String password, boolean excludeTags, boolean detailed, boolean transcript) {
        if (StringUtils.isEmpty((Object)slideshowId) && StringUtils.isEmpty((Object)slideshowUrl)) {
            throw new SlideShareException("slideshow", "slideshowId and slideshowUrl are empty");
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)GET_SLIDESHOW_URL);
        if (StringUtils.hasLength((String)slideshowId)) {
            builder.queryParam("slideshow_id", new Object[]{slideshowId});
        }
        if (StringUtils.hasLength((String)slideshowUrl)) {
            builder.queryParam("slideshow_id", new Object[]{slideshowUrl});
        }
        if (StringUtils.hasLength((String)username)) {
            builder.queryParam("username", new Object[]{username});
        }
        if (StringUtils.hasLength((String)password)) {
            builder.queryParam("password", new Object[]{password});
        }
        builder.queryParam("exclude_tags", new Object[]{excludeTags ? "1" : "0"});
        builder.queryParam("detailed", new Object[]{detailed ? "1" : "0"});
        builder.queryParam("get_transcript", new Object[]{transcript ? "1" : "0"});
        String url = builder.toUriString();
        Slideshow slideshow = (Slideshow)this.restOperations.getForObject(url, Slideshow.class, new Object[0]);
        return slideshow;
    }

    @Override
    public GetSlideshowsResponse getSlideshowsByTag(String tag, int limit) {
        return this.getSlideshowsByTag(tag, limit, 0, true);
    }

    @Override
    public GetSlideshowsResponse getSlideshowsByTag(String tag, int limit, int offset, boolean detailed) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)GET_SLIDESHOWS_BY_TAG_URL);
        builder.queryParam("tag", new Object[]{tag});
        builder.queryParam("limit", new Object[]{limit});
        if (offset > 0) {
            builder.queryParam("offset", new Object[]{offset});
        }
        if (detailed) {
            builder.queryParam("detailed", new Object[]{1});
        }
        String url = builder.toUriString();
        GetSlideshowsResponse response = (GetSlideshowsResponse)this.restOperations.getForObject(url, GetSlideshowsResponse.class, new Object[0]);
        response.setRequestType(GetSlideshowsResponse.RequestType.BY_TAG);
        return response;
    }

    @Override
    public GetSlideshowsResponse getSlideshowsByGroup(String groupName, int limit) {
        return this.getSlideshowsByGroup(groupName, limit, 0, true);
    }

    @Override
    public GetSlideshowsResponse getSlideshowsByGroup(String groupName, int limit, int offset, boolean detailed) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)GET_SLIDESHOWS_BY_GROUP_URL);
        builder.queryParam("group_name", new Object[]{groupName});
        builder.queryParam("limit", new Object[]{limit});
        if (offset > 0) {
            builder.queryParam("offset", new Object[]{offset});
        }
        if (detailed) {
            builder.queryParam("detailed", new Object[]{1});
        }
        String url = builder.toUriString();
        GetSlideshowsResponse response = (GetSlideshowsResponse)this.restOperations.getForObject(url, GetSlideshowsResponse.class, new Object[0]);
        response.setRequestType(GetSlideshowsResponse.RequestType.BY_GROUP);
        return response;
    }

    @Override
    public GetSlideshowsResponse getSlideshowsByUser(String usernameFor, int limit) {
        return this.getSlideshowsByUser(usernameFor, null, null, limit, 0, true, false);
    }

    @Override
    public GetSlideshowsResponse getSlideshowsByUser(String usernameFor, String username, String password, int limit) {
        return this.getSlideshowsByUser(usernameFor, username, password, limit, 0, true, false);
    }

    @Override
    public GetSlideshowsResponse getSlideshowsByUser(String usernameFor, String username, String password, int limit, int offset, boolean detailed, boolean getUnconverted) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)GET_SLIDESHOWS_BY_USER_URL);
        builder.queryParam("username_for", new Object[]{usernameFor});
        builder.queryParam("limit", new Object[]{limit});
        if (StringUtils.hasLength((String)username)) {
            builder.queryParam("username", new Object[]{username});
        }
        if (StringUtils.hasLength((String)password)) {
            builder.queryParam("password", new Object[]{password});
        }
        if (offset > 0) {
            builder.queryParam("offset", new Object[]{offset});
        }
        if (detailed) {
            builder.queryParam("detailed", new Object[]{1});
        }
        if (getUnconverted) {
            builder.queryParam("get_unconverted", new Object[]{1});
        }
        String url = builder.toUriString();
        GetSlideshowsResponse response = (GetSlideshowsResponse)this.restOperations.getForObject(url, GetSlideshowsResponse.class, new Object[0]);
        response.setRequestType(GetSlideshowsResponse.RequestType.BY_USER);
        return response;
    }

    @Override
    public SearchSlideshowsResponse searchSlideshows(String q) {
        return this.searchSlideshows(q, 0, 0, null, null, null, null, false, null, null, false, false, false, true, true);
    }

    @Override
    public SearchSlideshowsResponse searchSlideshows(String q, int page) {
        return this.searchSlideshows(q, page, 0, null, null, null, null, false, null, null, false, false, false, true, true);
    }

    @Override
    public SearchSlideshowsResponse searchSlideshows(String q, int page, int itemsPerPage) {
        return this.searchSlideshows(q, page, itemsPerPage, null, null, null, null, false, null, null, false, false, false, true, true);
    }

    @Override
    public SearchSlideshowsResponse searchSlideshows(String q, int page, int itemsPerPage, SearchOptions.Language lang, SearchOptions.Sort sort, SearchOptions.UploadDate uploadDate, SearchOptions.SearchType searchType, boolean downloadableOnly, SearchOptions.FileFormat fileformat, SearchOptions.FileType fileType, boolean isCC, boolean isCCAdapt, boolean isCCCommercial, boolean detailed, boolean transcript) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)SEARCH_SLIDESHOWS_URL);
        builder.queryParam("q", new Object[]{q});
        if (page > 0) {
            builder.queryParam("page", new Object[]{page});
        }
        if (itemsPerPage > 0) {
            builder.queryParam("items_per_page", new Object[]{itemsPerPage});
        }
        if (lang != null) {
            builder.queryParam("lang", new Object[]{lang.toCode()});
        }
        if (sort != null) {
            builder.queryParam("sort", new Object[]{sort.toString().toLowerCase()});
        }
        if (uploadDate != null) {
            builder.queryParam("upload_date", new Object[]{uploadDate.toString().toLowerCase()});
        }
        if (searchType != null) {
            builder.queryParam("what", new Object[]{searchType.toString().toLowerCase()});
        }
        if (downloadableOnly) {
            builder.queryParam("download", new Object[]{0});
        }
        if (fileformat != null) {
            builder.queryParam("fileformat", new Object[]{fileformat.toString().toLowerCase()});
        }
        if (fileType != null) {
            builder.queryParam("file_type", new Object[]{fileType.toString().toLowerCase()});
        }
        if (isCC) {
            builder.queryParam("cc", new Object[]{1});
        }
        if (isCCAdapt) {
            builder.queryParam("cc_adapt", new Object[]{1});
        }
        if (isCCCommercial) {
            builder.queryParam("cc_commercial", new Object[]{1});
        }
        if (detailed) {
            builder.queryParam("detailed", new Object[]{1});
            if (transcript) {
                builder.queryParam("get_transcript", new Object[]{1});
            }
        }
        String url = builder.toUriString();
        SearchSlideshowsResponse response = (SearchSlideshowsResponse)this.restOperations.getForObject(url, SearchSlideshowsResponse.class, new Object[0]);
        return response;
    }

    @Override
    public String editSlideshow(String username, String password, String slideshowId, String slideshowTitle, String slideshowDescription, Collection<String> slideshowTags, PrivacySetting privacySetting) {
        if (privacySetting == null) {
            return this.editSlideshow(username, password, slideshowId, slideshowTitle, slideshowDescription, slideshowTags, null, null, null, null);
        }
        return this.editSlideshow(username, password, slideshowId, slideshowTitle, slideshowDescription, slideshowTags, privacySetting.getMakeSlideshowPrivate(), privacySetting.getGenerateSecretUrl(), privacySetting.getAllowEmbeds(), privacySetting.getShareWithContacts());
    }

    @Override
    public String editSlideshow(String username, String password, String slideshowId, String slideshowTitle, String slideshowDescription, Collection<String> slideshowTags, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)EDIT_SLIDESHOW_URL);
        builder.queryParam("username", new Object[]{username});
        builder.queryParam("password", new Object[]{password});
        builder.queryParam("slideshow_id", new Object[]{slideshowId});
        if (StringUtils.hasLength((String)slideshowTitle)) {
            builder.queryParam("slideshow_title", new Object[]{slideshowTitle});
        }
        if (StringUtils.hasLength((String)slideshowDescription)) {
            builder.queryParam("slideshow_description", new Object[]{slideshowDescription});
        }
        if (slideshowTags != null) {
            builder.queryParam("slideshow_tags", new Object[]{StringUtils.collectionToCommaDelimitedString(slideshowTags)});
        }
        this.setUpPrivacySettings(builder, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
        String url = builder.toUriString();
        SlideshowIdHolder response = (SlideshowIdHolder)this.restOperations.getForObject(url, SlideshowIdHolder.class, new Object[0]);
        return response.getId();
    }

    private void setUpPrivacySettings(UriComponentsBuilder builder, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        if (makeSlideshowPrivate != null) {
            if (makeSlideshowPrivate.booleanValue()) {
                builder.queryParam("make_slideshow_private", new Object[]{"Y"});
                if (generateSecretUrl != null) {
                    builder.queryParam("generate_secret_url", new Object[]{generateSecretUrl != false ? "Y" : "N"});
                }
                if (allowEmbeds != null) {
                    builder.queryParam("allow_embeds", new Object[]{allowEmbeds != false ? "Y" : "N"});
                }
                if (shareWithContacts != null) {
                    builder.queryParam("share_with_contacts", new Object[]{shareWithContacts != false ? "Y" : "N"});
                }
            } else {
                builder.queryParam("make_slideshow_private", new Object[]{"N"});
            }
        }
    }

    @Override
    public String deleteSlideshow(String username, String password, String slideshowId) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)DELETE_SLIDESHOW_URL);
        builder.queryParam("username", new Object[]{username});
        builder.queryParam("password", new Object[]{password});
        builder.queryParam("slideshow_id", new Object[]{slideshowId});
        String url = builder.toUriString();
        SlideshowIdHolder response = (SlideshowIdHolder)this.restOperations.getForObject(url, SlideshowIdHolder.class, new Object[0]);
        return response.getId();
    }

    @Override
    public String uploadSlideshowFromUrl(String username, String password, String uploadUrl, String title, String description, Collection<String> tags, Boolean makeSrcPublic) {
        return this.uploadSlideshowFromUrl(username, password, uploadUrl, title, description, tags, makeSrcPublic, null, null, null, null);
    }

    @Override
    public String uploadSlideshowFromUrl(String username, String password, String uploadUrl, String title, String description, Collection<String> tags, Boolean makeSrcPublic, PrivacySetting privacySetting) {
        if (privacySetting == null) {
            return this.uploadSlideshowFromUrl(username, password, uploadUrl, title, description, tags, makeSrcPublic, null, null, null, null);
        }
        return this.uploadSlideshowFromUrl(username, password, uploadUrl, title, description, tags, makeSrcPublic, privacySetting.getMakeSlideshowPrivate(), privacySetting.getGenerateSecretUrl(), privacySetting.getAllowEmbeds(), privacySetting.getShareWithContacts());
    }

    @Override
    public String uploadSlideshowFromUrl(String username, String password, String uploadUrl, String title, String description, Collection<String> tags, Boolean makeSrcPublic, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)UPLOAD_SLIDESHOW_URL);
        builder.queryParam("username", new Object[]{username});
        builder.queryParam("password", new Object[]{password});
        builder.queryParam("upload_url", new Object[]{uploadUrl});
        builder.queryParam("slideshow_title", new Object[]{title});
        this.populateSlideshowUploadOptionalParameters(builder, description, tags, makeSrcPublic, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
        String url = builder.toUriString();
        SlideshowIdHolder response = (SlideshowIdHolder)this.restOperations.getForObject(url, SlideshowIdHolder.class, new Object[0]);
        return response.getId();
    }

    @Override
    public String uploadSlideshowFromFile(String username, String password, File slideshowFile, String title, String description) {
        return this.uploadSlideshowFromFile(username, password, slideshowFile, title, description, null, true, null, null, null, null);
    }

    @Override
    public String uploadSlideshowFromFile(String username, String password, File slideshowFile, String title, String description, Collection<String> tags, boolean makeSrcPublic, PrivacySetting privacySetting) {
        if (privacySetting == null) {
            return this.uploadSlideshowFromFile(username, password, slideshowFile, title, description, tags, makeSrcPublic, null, null, null, null);
        }
        return this.uploadSlideshowFromFile(username, password, slideshowFile, title, description, tags, makeSrcPublic, privacySetting.getMakeSlideshowPrivate(), privacySetting.getGenerateSecretUrl(), privacySetting.getAllowEmbeds(), privacySetting.getShareWithContacts());
    }

    @Override
    public String uploadSlideshowFromFile(String username, String password, File slideshowFile, String title, String description, Collection<String> tags, boolean makeSrcPublic, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        FileSystemResource slideshowResource = new FileSystemResource(slideshowFile);
        return this.uploadSlideshowResource(username, password, (Resource)slideshowResource, title, description, tags, makeSrcPublic, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
    }

    @Override
    public String uploadSlideshowFromFile(String username, String password, String slideshowFilePath, String title, String description, Collection<String> tags, boolean makeSrcPublic, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        FileSystemResource slideshowResource = new FileSystemResource(slideshowFilePath);
        return this.uploadSlideshowResource(username, password, (Resource)slideshowResource, title, description, tags, makeSrcPublic, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
    }

    @Override
    public String uploadSlideshowFromContent(String username, String password, String slideshowContent, String filename, String title, String description, Collection<String> tags, boolean makeSrcPublic, PrivacySetting privacySetting) {
        if (privacySetting == null) {
            return this.uploadSlideshowFromContent(username, password, slideshowContent.getBytes(), filename, title, description, tags, makeSrcPublic, null, null, null, null);
        }
        return this.uploadSlideshowFromContent(username, password, slideshowContent.getBytes(), filename, title, description, tags, makeSrcPublic, privacySetting.getMakeSlideshowPrivate(), privacySetting.getGenerateSecretUrl(), privacySetting.getAllowEmbeds(), privacySetting.getShareWithContacts());
    }

    @Override
    public String uploadSlideshowFromContent(String username, String password, String slideshowContent, String filename, String title, String description, Collection<String> tags, boolean makeSrcPublic, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        return this.uploadSlideshowFromContent(username, password, slideshowContent.getBytes(), filename, title, description, tags, makeSrcPublic, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
    }

    @Override
    public String uploadSlideshowFromContent(String username, String password, byte[] slideshowContent, final String filename, String title, String description, Collection<String> tags, boolean makeSrcPublic, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        ByteArrayResource resource = new ByteArrayResource(slideshowContent){

            public String getFilename() {
                return filename;
            }
        };
        return this.uploadSlideshowResource(username, password, (Resource)resource, title, description, tags, makeSrcPublic, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
    }

    @Override
    public String uploadSlideshowResource(String username, String password, Resource slideshowResource, String slideshowTitle, String slideshowDescription, Collection<String> slideshowTags, boolean makeSrcPublic, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)UPLOAD_SLIDESHOW_URL);
        builder.queryParam("username", new Object[]{username});
        builder.queryParam("password", new Object[]{password});
        builder.queryParam("slideshow_title", new Object[]{slideshowTitle});
        this.populateSlideshowUploadOptionalParameters(builder, slideshowDescription, slideshowTags, makeSrcPublic, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
        MultiValueMap params = builder.build().getQueryParams();
        LinkedMultiValueMap part = new LinkedMultiValueMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                part.add((Object)key, (Object)value);
            }
        }
        part.add((Object)"slideshow_srcfile", (Object)slideshowResource);
        String url = UPLOAD_SLIDESHOW_URL;
        SlideshowIdHolder response = (SlideshowIdHolder)this.restOperations.postForObject(url, (Object)part, SlideshowIdHolder.class, new Object[0]);
        return response.getId();
    }

    private void populateSlideshowUploadOptionalParameters(UriComponentsBuilder builder, String slideshowDescription, Collection<String> slideshowTags, Boolean makeSrcPublic, Boolean makeSlideshowPrivate, Boolean generateSecretUrl, Boolean allowEmbeds, Boolean shareWithContacts) {
        if (StringUtils.hasLength((String)slideshowDescription)) {
            builder.queryParam("slideshow_description", new Object[]{slideshowDescription});
        }
        if (slideshowTags != null) {
            builder.queryParam("slideshow_tags", new Object[]{StringUtils.collectionToCommaDelimitedString(slideshowTags)});
        }
        if (makeSrcPublic != null) {
            builder.queryParam("make_src_public", new Object[]{makeSrcPublic != false ? "Y" : "N"});
        }
        this.setUpPrivacySettings(builder, makeSlideshowPrivate, generateSecretUrl, allowEmbeds, shareWithContacts);
    }
}

