/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.slideshare.api.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.social.slideshare.api.SlideShare;
import org.springframework.social.slideshare.api.SlideshowOperations;
import org.springframework.social.slideshare.api.impl.SlideshareErrorHandler;
import org.springframework.social.slideshare.api.impl.SlideshowTemplate;
import org.springframework.social.slideshare.api.impl.xml.JacksonUtils;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.social.support.HttpRequestDecorator;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SlideShareTemplate
implements SlideShare {
    private static final Log logger = LogFactory.getLog(SlideShareTemplate.class);
    private final RestTemplate restTemplate = this.createRestTemplateWithCulledMessageConverters();
    private SlideshowOperations slideshowOperations;

    public SlideShareTemplate(String apiKey, String sharedSecret) {
        this.registerSlideShareInterceptor(apiKey, sharedSecret);
        this.configureRestTemplate(this.restTemplate);
        this.slideshowOperations = new SlideshowTemplate((RestOperations)this.restTemplate);
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new SlideshareErrorHandler());
    }

    protected void registerSlideShareInterceptor(String apiKey, String sharedSecret) {
        List interceptors = this.restTemplate.getInterceptors();
        interceptors.add(new SlideShareApiValidationParameterRequestInterceptor(apiKey, sharedSecret));
        this.restTemplate.setInterceptors(interceptors);
    }

    protected RestTemplate createRestTemplateWithCulledMessageConverters() {
        ClientHttpRequestFactory requestFactory = ClientHttpRequestFactorySelector.getRequestFactory();
        ClientHttpRequestFactory bufferedRequestFactory = ClientHttpRequestFactorySelector.bufferRequests((ClientHttpRequestFactory)requestFactory);
        List<HttpMessageConverter<?>> messageConverters = this.getMessageConverters();
        RestTemplate client = new RestTemplate(messageConverters);
        client.setRequestFactory(bufferedRequestFactory);
        return client;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        messageConverters.add(this.getXmlConverter());
        return messageConverters;
    }

    protected HttpMessageConverter<?> getXmlConverter() {
        MappingJackson2XmlHttpMessageConverter converter = new MappingJackson2XmlHttpMessageConverter();
        converter.setObjectMapper((ObjectMapper)JacksonUtils.XML_MAPPER);
        return converter;
    }

    @Override
    public SlideshowOperations slideshowOperations() {
        return this.slideshowOperations;
    }

    public boolean isAuthorized() {
        return false;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    private static final class SlideShareApiValidationParameterRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private final String apiKey;
        private final String sharedSecret;

        public SlideShareApiValidationParameterRequestInterceptor(String apiKey, String sharedSecret) {
            this.apiKey = apiKey;
            this.sharedSecret = sharedSecret;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpRequestDecorator protectedResourceRequest = new HttpRequestDecorator(request){

                public URI getURI() {
                    String ts = Long.toString(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
                    String hash = DigestUtils.sha1Hex((String)(SlideShareApiValidationParameterRequestInterceptor.this.sharedSecret + ts)).toLowerCase();
                    UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)super.getURI());
                    builder.queryParam("api_key", new Object[]{SlideShareApiValidationParameterRequestInterceptor.this.apiKey});
                    builder.queryParam("ts", new Object[]{ts});
                    builder.queryParam("hash", new Object[]{hash});
                    UriComponents uriComponents = builder.build(true);
                    logger.debug((Object)("requesting SlideShare API: " + uriComponents.toUriString()));
                    return uriComponents.toUri();
                }
            };
            return execution.execute((HttpRequest)protectedResourceRequest, body);
        }
    }
}

