/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.concurrent;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedTask
implements Delayed,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DelayedTask.class);
    private final long trigger;
    private final Runnable runnable;

    public DelayedTask(Runnable runnable, long delay, TimeUnit unit) {
        this.runnable = runnable;
        this.trigger = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(delay, unit);
    }

    @Override
    public int compareTo(Delayed o) {
        long other = ((DelayedTask)o).trigger;
        int returnValue = this.trigger < other ? -1 : (this.trigger > other ? 1 : 0);
        return returnValue;
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        long n = this.trigger - System.currentTimeMillis();
        logger.debug("delay is {} milli-seconds", (Object)n);
        return timeUnit.convert(n, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        this.runnable.run();
    }
}

