/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.turnbig.pandora.concurrent.DelayedTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DelayedThreadPoolExecutor.class);

    public DelayedThreadPoolExecutor(int corePoolSize, int maximumPoolSize) {
        super(corePoolSize, maximumPoolSize, 0L, TimeUnit.SECONDS, new DelayQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Common-delay-pool-%d").build());
        logger.info("Submit a do nothing task to initial delayed thread pool executor");
        int i = 0;
        while (i < maximumPoolSize) {
            final int idx = i++;
            this.submit(new Runnable(){

                @Override
                public void run() {
                    logger.info("Initial delayed thread pool executor {}", (Object)idx);
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new DelayedFutureTask<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new DelayedFutureTask<T>(callable);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(new DelayedTask(task, 60L, TimeUnit.SECONDS));
    }

    public Future<?> submit(Runnable task, long delay, TimeUnit unit) {
        return super.submit(new DelayedTask(task, delay, unit));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new RuntimeException("not implemented");
    }

    static class DelayedFutureTask<V>
    extends FutureTask<V>
    implements Delayed {
        DelayedTask delayedTask;

        DelayedFutureTask(Callable<V> callable) {
            super(callable);
            this.delayedTask = (DelayedTask)((Object)callable);
        }

        DelayedFutureTask(Runnable runnable, V result) {
            super(runnable, result);
            this.delayedTask = (DelayedTask)runnable;
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delayedTask.compareTo(((DelayedFutureTask)o).getDelayedTask());
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delayedTask.getDelay(unit);
        }

        public DelayedTask getDelayedTask() {
            return this.delayedTask;
        }
    }
}

