/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.conversion;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class StringToDateConverter
implements Converter<String, Date> {
    private DateFormat[] getDateFormats(Locale locale) {
        SimpleDateFormat ls = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat ss = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat dt1 = DateFormat.getDateTimeInstance(3, 1, locale);
        DateFormat dt2 = DateFormat.getDateTimeInstance(3, 2, locale);
        DateFormat dt3 = DateFormat.getDateTimeInstance(3, 3, locale);
        DateFormat d1 = DateFormat.getDateInstance(3, locale);
        DateFormat d2 = DateFormat.getDateInstance(2, locale);
        DateFormat d3 = DateFormat.getDateInstance(1, locale);
        SimpleDateFormat rfc3399 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return new DateFormat[]{ls, ss, dt1, dt2, dt3, rfc3399, d1, d2, d3};
    }

    private Date doConvertToDate(Object value, Locale locale) {
        Date result = null;
        if (value instanceof String) {
            DateFormat[] dfs;
            if (StringUtils.isNumeric((CharSequence)value.toString())) {
                return new Date(Long.parseLong(value.toString()));
            }
            for (DateFormat df1 : dfs = this.getDateFormats(locale)) {
                try {
                    result = df1.parse(value.toString());
                    if (result == null) continue;
                    break;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            if (array.length >= 1) {
                Object v = array[0];
                result = this.doConvertToDate(v, locale);
            }
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            result = (Date)value;
        }
        return result;
    }

    public Date convert(String source) {
        return this.doConvertToDate(source, Locale.CHINA);
    }
}

