/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.turnbig.pandora.spring.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerHelper {
    private static Logger logger = LoggerFactory.getLogger(FreeMarkerHelper.class);
    private static Configuration configuration = (Configuration)SpringContextHolder.getBean("freemarkerConfigurer");

    public static Template getTemplate(String name) {
        try {
            return configuration.getTemplate(name);
        }
        catch (IOException e) {
            logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String getTplContent(String templateName) {
        try {
            Template template = FreeMarkerHelper.getTemplate(templateName);
            String result = FreeMarkerHelper.processTemplateIntoString(template, null);
            return result.trim();
        }
        catch (IOException e) {
            logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            logger.error("There got a grammar error in freemarker template " + templateName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String process(String templateName, Object model) {
        try {
            Template template = FreeMarkerHelper.getTemplate(templateName);
            return FreeMarkerHelper.processTemplateIntoString(template, model);
        }
        catch (IOException e) {
            logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            logger.error("There got a grammar error in freemarker template " + templateName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void process(String templateName, Object model, Writer writer) {
        try {
            Template template = FreeMarkerHelper.getTemplate(templateName);
            template.process(model, writer);
        }
        catch (IOException e) {
            logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            logger.error("There got a grammar error in freemarker template " + templateName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void processTemplateIntoString(String tplPath, Object model, Writer writer) {
        try {
            Template template = FreeMarkerHelper.getTemplate(tplPath);
            template.process(model, writer);
        }
        catch (IOException e) {
            logger.error("Error accour on reading freemarker template resource:" + tplPath, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            logger.error("There got a grammar error in freemarker template " + tplPath, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String processTemplateIntoString(Template template, Object model) throws IOException, TemplateException {
        StringWriter result = new StringWriter();
        template.process(model, (Writer)result);
        return result.toString();
    }
}

