/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.freemarker;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerRenderer {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerRenderer.class);
    static Configuration configuration = null;

    public static void init() {
        if (configuration == null) {
            StringTemplateLoader templateLoader = new StringTemplateLoader();
            Configuration config = new Configuration(Configuration.getVersion());
            config.setTemplateLoader((TemplateLoader)templateLoader);
            config.setTemplateUpdateDelayMilliseconds(Long.MAX_VALUE);
            config.setDefaultEncoding("UTF-8");
            configuration = config;
        }
    }

    public static String processTplContent(String templateContent, Object model) {
        try {
            if (templateContent != null) {
                Template template = new Template(RandomStringUtils.random((int)8), (Reader)new StringReader(templateContent), configuration);
                return FreemarkerRenderer.processTpl(template, model);
            }
            return null;
        }
        catch (IOException e) {
            logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            logger.error("There got a grammar error in freemarker template :" + templateContent, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String processTpl(Template template, Object model) throws IOException, TemplateException {
        FreemarkerRenderer.init();
        StringWriter result = new StringWriter();
        template.process(model, (Writer)result);
        return result.toString();
    }
}

