/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.freemarker;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.turnbig.pandora.freemarker.XmlTemplateLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateParser {
    private static final Logger logger = LoggerFactory.getLogger(TemplateParser.class);
    static JAXBContext ctx = null;

    public static JAXBContext getJaxbContext() {
        if (ctx == null) {
            try {
                ctx = JAXBContext.newInstance((Class[])new Class[]{XmlTemplateLoaderFactory.Template.class, XmlTemplateLoaderFactory.Templates.class});
            }
            catch (JAXBException e) {
                logger.error("could not create sql templates jaxb context", (Throwable)e);
            }
        }
        return ctx;
    }

    public static XmlTemplateLoaderFactory.Templates fromXML(String xml) {
        try {
            Unmarshaller um = TemplateParser.getJaxbContext().createUnmarshaller();
            XmlTemplateLoaderFactory.Templates unmarshal = (XmlTemplateLoaderFactory.Templates)um.unmarshal((Reader)new StringReader(xml));
            return unmarshal;
        }
        catch (JAXBException e) {
            throw new RuntimeException("could not parse sql-template-xml", e);
        }
    }

    public static XmlTemplateLoaderFactory.Templates fromXML(File f) {
        try {
            Unmarshaller um = TemplateParser.getJaxbContext().createUnmarshaller();
            XmlTemplateLoaderFactory.Templates unmarshal = (XmlTemplateLoaderFactory.Templates)um.unmarshal(f);
            return unmarshal;
        }
        catch (JAXBException e) {
            throw new RuntimeException("could not parse sql-template-xml", e);
        }
    }

    public static XmlTemplateLoaderFactory.Templates fromXML(InputStream is) {
        try {
            Unmarshaller um = TemplateParser.getJaxbContext().createUnmarshaller();
            XmlTemplateLoaderFactory.Templates unmarshal = (XmlTemplateLoaderFactory.Templates)um.unmarshal(is);
            return unmarshal;
        }
        catch (JAXBException e) {
            throw new RuntimeException("could not parse sql-template-xml", e);
        }
    }
}

