/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.freemarker;

import freemarker.cache.StringTemplateLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.turnbig.pandora.freemarker.TemplateParser;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class XmlTemplateLoaderFactory
implements FactoryBean<TemplateLoader>,
InitializingBean {
    private static final String TEMPLATE_SYNC_FOLDER = ".template.sync";
    private static Logger logger = LoggerFactory.getLogger(XmlTemplateLoaderFactory.class);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private String[] locations;
    private TemplateLoader sqlTemplateLoader = new TemplateLoader();
    private static String syncTemplateFolder;

    public void afterPropertiesSet() throws Exception {
        this.createTemplateLoader();
    }

    public TemplateLoader createTemplateLoader() throws IOException {
        syncTemplateFolder = MessageFormat.format("{0}{1}{2}", this.resourceLoader.getResource("/").getFile().getAbsolutePath(), File.separator, TEMPLATE_SYNC_FOLDER);
        new File(syncTemplateFolder).mkdirs();
        for (String path : this.locations) {
            this.loadTemplates(path);
        }
        return this.sqlTemplateLoader;
    }

    public void loadTemplates(String path) throws IOException {
        Resource r = this.resourceLoader.getResource(path);
        if (r.exists()) {
            List<Object> templates;
            block4: {
                templates = new ArrayList();
                try {
                    templates = XmlTemplateLoaderFactory.parseTemplate(r.getFile());
                }
                catch (Exception e) {
                    if (!path.endsWith(".xml")) break block4;
                    int n = path.contains("/") ? path.lastIndexOf("/") : path.indexOf(":");
                    String filename = path.substring(n + 1);
                    String syncToFileName = syncTemplateFolder + File.separator + filename;
                    logger.debug("It seems {} is not a disk file, sync to {}", (Object)syncToFileName);
                    InputStream is = r.getInputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(new File(syncToFileName)));
                    IOUtils.closeQuietly((InputStream)is);
                    templates = XmlTemplateLoaderFactory.parseTemplate(new File(syncToFileName));
                }
            }
            for (Template template : templates) {
                this.sqlTemplateLoader.putTemplate(template.getName(), template.getTemplate(), template.getLastModified());
                this.sqlTemplateLoader.addMapper(this.sqlTemplateLoader.findTemplateSource(template.getName()), template.getTplFilePath());
            }
        }
    }

    public static List<Template> parseTemplate(InputStream is) throws IOException {
        String content = IOUtils.toString((InputStream)is);
        logger.debug("It seems the template is in JAR file, copy it to {}", (Object)syncTemplateFolder);
        ArrayList<Template> list = new ArrayList<Template>();
        Templates templates = TemplateParser.fromXML(content);
        for (Template sqlTemplate : templates.getTemplates()) {
            sqlTemplate.setLastModified(new Date().getTime());
            sqlTemplate.setTplFilePath("");
            list.add(sqlTemplate);
        }
        return list;
    }

    public static List<Template> parseTemplate(File file) {
        ArrayList<Template> result;
        block3: {
            File[] files;
            block2: {
                result = new ArrayList<Template>();
                if (!file.isFile()) break block2;
                logger.debug("load template from : {}", (Object)file.getAbsolutePath());
                Templates templates = TemplateParser.fromXML(file);
                for (Template sqlTemplate : templates.getTemplates()) {
                    sqlTemplate.setLastModified(file.lastModified());
                    sqlTemplate.setTplFilePath(file.getAbsolutePath());
                    result.add(sqlTemplate);
                }
                break block3;
            }
            if (!file.isDirectory()) break block3;
            logger.debug("load template from folder : {}", (Object)file.getAbsolutePath());
            for (File f : files = file.listFiles()) {
                result.addAll(XmlTemplateLoaderFactory.parseTemplate(f));
            }
        }
        return result;
    }

    public TemplateLoader getObject() throws Exception {
        return this.sqlTemplateLoader;
    }

    public Class<TemplateLoader> getObjectType() {
        return TemplateLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public TemplateLoader getSqlTemplateLoader() {
        return this.sqlTemplateLoader;
    }

    @XmlRootElement(name="Template")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Template {
        @XmlElement(name="name")
        private String name;
        @XmlElement(name="template")
        private String template;
        private long lastModified;
        private String tplFilePath;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public String toString() {
            return "XmlTemplate [name=" + this.name + ", template=" + this.template + ", lastModified=" + this.lastModified + "]";
        }

        public String getTplFilePath() {
            return this.tplFilePath;
        }

        public void setTplFilePath(String tplFilePath) {
            this.tplFilePath = tplFilePath;
        }
    }

    @XmlRootElement(name="Templates")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Templates {
        @XmlElement(name="Template")
        List<Template> templates = new ArrayList<Template>();

        public List<Template> getTemplates() {
            return this.templates;
        }

        public void setTemplates(List<Template> templates) {
            this.templates = templates;
        }
    }

    public static class TemplateLoader
    extends StringTemplateLoader {
        private HashMap<Object, String> resourceMapper = new HashMap();

        public Object findTemplateSource(String name) {
            Object stringTemplateSource = super.findTemplateSource(name);
            if (stringTemplateSource != null && this.resourceMapper.containsKey(stringTemplateSource)) {
                String path = this.resourceMapper.get(stringTemplateSource);
                List<Template> tpls = XmlTemplateLoaderFactory.parseTemplate(new File(path));
                for (Template xmlTemplate : tpls) {
                    this.putTemplate(xmlTemplate.getName(), xmlTemplate.getTemplate(), xmlTemplate.getLastModified());
                    this.addMapper(super.findTemplateSource(name), xmlTemplate.getTplFilePath());
                }
            }
            return super.findTemplateSource(name);
        }

        public long getLastModified(Object templateSource) {
            String path = this.resourceMapper.get(templateSource);
            File f = new File(path);
            return f.lastModified();
        }

        public void addMapper(Object object, String path) {
            this.resourceMapper.put(object, path);
        }
    }
}

