/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.httpclient;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedPlainConnectionSocketFactory
extends PlainConnectionSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProxiedPlainConnectionSocketFactory.class);

    public Socket createSocket(HttpContext context) throws IOException {
        InetSocketAddress addr;
        if (context != null && (addr = (InetSocketAddress)context.getAttribute("proxy.socks.address")) != null) {
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, addr);
            return new Socket(proxy);
        }
        logger.debug("no proxy socks address is configurated, connect directly");
        return super.createSocket(context);
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        InetSocketAddress addr;
        if (context != null && (addr = (InetSocketAddress)context.getAttribute("proxy.socks.address")) != null) {
            remoteAddress = InetSocketAddress.createUnresolved(host.getHostName(), remoteAddress.getPort());
        }
        return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
    }
}

