/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMapper {
    private static Logger logger = LoggerFactory.getLogger(JsonMapper.class);
    private ObjectMapper mapper = new ObjectMapper();

    public JsonMapper() {
        this(null);
    }

    public JsonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static JsonMapper nonEmptyMapper() {
        return new JsonMapper(JsonInclude.Include.NON_EMPTY);
    }

    public static JsonMapper nonDefaultMapper() {
        return new JsonMapper(JsonInclude.Include.NON_DEFAULT);
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("write to json string error:" + object, (Throwable)e);
            return null;
        }
    }

    public <T> T getBean(String jsonString, Class<T> beanClazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, beanClazz);
        }
        catch (Exception e) {
            logger.warn("convert string to bean.", (Throwable)e);
            return null;
        }
    }

    public <T> List<T> getListBean(String jsonString, Class<T> beanClazz) {
        try {
            JavaType typeRef = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{beanClazz});
            return (List)this.mapper.readValue(jsonString, typeRef);
        }
        catch (Exception e) {
            logger.warn("convert string to list bean.", (Throwable)e);
            return null;
        }
    }

    public <K, V> HashMap<K, V> getMapBean(String jsonString, Class<K> keyClazz, Class<V> valueClazz) {
        try {
            MapType typeRef = TypeFactory.defaultInstance().constructMapType(HashMap.class, keyClazz, valueClazz);
            return (HashMap)this.mapper.readValue(jsonString, (JavaType)typeRef);
        }
        catch (Exception e) {
            logger.warn("convert string to map bean.", (Throwable)e);
            return null;
        }
    }

    public <T> T getBean(String jsonString, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(jsonString, type);
        }
        catch (Exception e) {
            logger.warn("convert string to bean.", (Throwable)e);
            return null;
        }
    }

    public void update(String jsonString, Object object) {
        try {
            this.mapper.readerForUpdating(object).readValue(jsonString);
        }
        catch (JsonProcessingException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
    }

    public String toJsonP(String functionName, Object object) {
        return this.toJson(new JSONPObject(functionName, object));
    }

    public void enableEnumUseToString() {
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    public void enableJaxbAnnotation() {
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.mapper.registerModule((Module)module);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

