/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.spring.env.redis;

import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisPropertySource
extends PropertySource<RedisTemplate<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(RedisPropertySource.class);
    public static String DEFAULT_NAME = "Redis-Based-Property-Source";
    public static String DEFAULT_KEY = "property:source";
    public static String INIT_PROPERTY_FILE_PATH = "classpath:redis-property-source.properties";
    StringRedisTemplate redisTemplate;
    String key = DEFAULT_KEY;

    public RedisPropertySource(ConfigurableApplicationContext context) {
        this(context, DEFAULT_NAME, DEFAULT_KEY);
    }

    public RedisPropertySource(ConfigurableApplicationContext context, String name) {
        this(context, name, DEFAULT_KEY);
    }

    public RedisPropertySource(ConfigurableApplicationContext context, String name, String key) {
        super(name);
        this.key = key == null ? DEFAULT_KEY : key;
        this.initialRedisTemplate(context);
        this.initialRedisPropertySource(context);
    }

    public void initialRedisPropertySource(ConfigurableApplicationContext context) {
        Resource resource;
        if (this.redisTemplate != null && (resource = context.getResource(INIT_PROPERTY_FILE_PATH)).exists()) {
            try {
                String[] propertyNames;
                ResourcePropertySource propertySource = new ResourcePropertySource(resource);
                for (String propertyName : propertyNames = propertySource.getPropertyNames()) {
                    if (this.containsProperty(propertyName)) continue;
                    String property = propertySource.getProperty(propertyName).toString();
                    this.redisTemplate.opsForHash().put((Object)this.key, (Object)propertyName, (Object)property);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void initialRedisTemplate(ConfigurableApplicationContext context) {
        Map beans = context.getBeansOfType(StringRedisTemplate.class);
        if (beans.size() == 1) {
            this.redisTemplate = (StringRedisTemplate)context.getBean(StringRedisTemplate.class);
        } else if (beans.size() > 1) {
            this.redisTemplate = (StringRedisTemplate)context.getBean("stringRedisTemplate", StringRedisTemplate.class);
        } else if (beans.size() == 0) {
            logger.warn("No qualifying bean of type 'org.springframework.data.redis.core.StringRedisTemplate<' available, expect at least one");
        } else {
            logger.warn("No qualifying bean of type 'org.springframework.data.redis.core.StringRedisTemplate' available, more than one found, but none named 'stringRedisTemplate'");
        }
    }

    public Object getProperty(String name) {
        if (this.redisTemplate != null) {
            return this.redisTemplate.opsForHash().get((Object)this.key, (Object)name);
        }
        return null;
    }

    public boolean containsProperty(String name) {
        return super.containsProperty(name);
    }

    public void setKey(String key) {
        this.key = key;
    }
}

