/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.turnbig.pandora.conversion.StringToDateConverter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class WebMvcConfiguration
extends WebMvcConfigurationSupport {
    @Value(value="${spring.jackson.serialization.indent_output:false}")
    boolean indentOutput = false;

    public void configureMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        stringConverter.setWriteAcceptCharset(false);
        messageConverters.add((HttpMessageConverter<?>)stringConverter);
        ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().simpleDateFormat("yyyy-MM-dd HH:mm:ss").indentOutput(this.indentOutput).serializationInclusion(JsonInclude.Include.NON_NULL).timeZone(TimeZone.getDefault()).applicationContext(this.getApplicationContext()).build();
        messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(objectMapper));
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter(String.class, Date.class, (Converter)new StringToDateConverter());
        registry.addConverter(String.class, String.class, source -> {
            String trim = source.trim();
            return "".equals(trim) ? null : trim;
        });
        registry.addConverter(String.class, MultipartFile.class, (Converter)new Converter<String, MultipartFile>(){

            public MultipartFile convert(String source) {
                if (StringUtils.isBlank((CharSequence)source)) {
                    return null;
                }
                return null;
            }
        });
    }
}

