/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.stereotype.Component;

@Configuration
public class ShiroLikeMethodSecurityConfiguration {

    static class ShiroLikeMethodSecurityExpressionRoot
    implements MethodSecurityExpressionOperations {
        protected static final String WILDCARD_TOKEN = "*";
        protected static final String PART_DIVIDER_TOKEN = ":";
        protected static final String SUBPART_DIVIDER_TOKEN = ",";
        protected static final boolean DEFAULT_CASE_SENSITIVE = false;
        protected final Authentication authentication;
        private AuthenticationTrustResolver trustResolver;
        private RoleHierarchy roleHierarchy;
        private Set<String> roles;
        private String defaultRolePrefix = "ROLE_";
        private Object filterObject;
        private Object returnObject;
        private Object target;
        public final boolean permitAll = true;
        public final boolean denyAll = false;
        private PermissionEvaluator permissionEvaluator;
        public final String read = "read";
        public final String write = "write";
        public final String create = "create";
        public final String delete = "delete";
        public final String admin = "administration";

        public ShiroLikeMethodSecurityExpressionRoot(Authentication authentication) {
            if (authentication == null) {
                throw new IllegalArgumentException("Authentication object cannot be null");
            }
            this.authentication = authentication;
        }

        public final boolean hasAuthority(String authority) {
            return this.hasAnyAuthority(authority);
        }

        public final boolean hasAnyAuthority(String ... authorities) {
            return this.hasAnyAuthorityName(Arrays.asList(authorities));
        }

        public final boolean hasRole(String role) {
            return this.hasAnyRole(role);
        }

        public final boolean hasAnyRole(String ... roles) {
            List<String> collect = Arrays.stream(roles).map(role -> ShiroLikeMethodSecurityExpressionRoot.getRoleWithDefaultPrefix(this.defaultRolePrefix, role)).collect(Collectors.toList());
            return this.hasAnyAuthorityName(collect);
        }

        private boolean hasAnyAuthorityName(List<String> authorities) {
            Set<String> authoritySet = this.getAuthoritySet();
            boolean exactMatches = authoritySet.stream().anyMatch(authorities::contains);
            if (exactMatches) {
                return true;
            }
            boolean wildcardMatches = authoritySet.stream().anyMatch(grantAuthority -> {
                if (WILDCARD_TOKEN.equals(grantAuthority)) {
                    return true;
                }
                if (authorities.contains(grantAuthority)) {
                    return true;
                }
                List<List<String>> grantParts = this.getParts((String)grantAuthority, false);
                return authorities.stream().anyMatch(requiredAuthority -> {
                    List<List<String>> requiredParts = this.getParts((String)requiredAuthority, false);
                    int i = 0;
                    for (List<String> otherPart : requiredParts) {
                        if (grantParts.size() - 1 < i) {
                            return true;
                        }
                        List part = (List)grantParts.get(i);
                        if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                            return false;
                        }
                        ++i;
                    }
                    while (i < grantParts.size()) {
                        List part = (List)grantParts.get(i);
                        if (!part.contains(WILDCARD_TOKEN)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                });
            });
            return wildcardMatches;
        }

        protected List<List<String>> getParts(String wildcardString, boolean caseSensitive) {
            String[] mainParts;
            if (wildcardString == null || wildcardString.trim().isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot be null or empty. Make sure permission strings are properly formatted.");
            }
            if (!caseSensitive) {
                wildcardString = wildcardString.toLowerCase();
            }
            ArrayList<List<String>> parts = new ArrayList<List<String>>();
            for (String part : mainParts = wildcardString.split(PART_DIVIDER_TOKEN)) {
                String[] subParts = part.split(SUBPART_DIVIDER_TOKEN);
                if (subParts.length == 0) {
                    throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.");
                }
                parts.add(Arrays.asList(subParts));
            }
            if (parts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
            }
            return parts;
        }

        public final Authentication getAuthentication() {
            return this.authentication;
        }

        public final boolean permitAll() {
            return true;
        }

        public final boolean denyAll() {
            return false;
        }

        public final boolean isAnonymous() {
            return this.trustResolver.isAnonymous(this.authentication);
        }

        public final boolean isAuthenticated() {
            return !this.isAnonymous();
        }

        public final boolean isRememberMe() {
            return this.trustResolver.isRememberMe(this.authentication);
        }

        public final boolean isFullyAuthenticated() {
            return !this.trustResolver.isAnonymous(this.authentication) && !this.trustResolver.isRememberMe(this.authentication);
        }

        public Object getPrincipal() {
            return this.authentication.getPrincipal();
        }

        public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
            this.trustResolver = trustResolver;
        }

        public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
            this.roleHierarchy = roleHierarchy;
        }

        public void setDefaultRolePrefix(String defaultRolePrefix) {
            this.defaultRolePrefix = defaultRolePrefix;
        }

        private Set<String> getAuthoritySet() {
            if (this.roles == null) {
                this.roles = new HashSet<String>();
                Collection userAuthorities = this.authentication.getAuthorities();
                if (this.roleHierarchy != null) {
                    userAuthorities = this.roleHierarchy.getReachableGrantedAuthorities(userAuthorities);
                }
                this.roles = AuthorityUtils.authorityListToSet((Collection)userAuthorities);
            }
            return this.roles;
        }

        public boolean hasPermission(Object target, Object permission) {
            return this.permissionEvaluator.hasPermission(this.authentication, target, permission);
        }

        public boolean hasPermission(Object targetId, String targetType, Object permission) {
            return this.permissionEvaluator.hasPermission(this.authentication, (Serializable)targetId, targetType, permission);
        }

        public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
            this.permissionEvaluator = permissionEvaluator;
        }

        private static String getRoleWithDefaultPrefix(String defaultRolePrefix, String role) {
            if (role == null) {
                return role;
            }
            if (defaultRolePrefix == null || defaultRolePrefix.length() == 0) {
                return role;
            }
            if (role.startsWith(defaultRolePrefix)) {
                return role;
            }
            return defaultRolePrefix + role;
        }

        public void setFilterObject(Object filterObject) {
            this.filterObject = filterObject;
        }

        public Object getFilterObject() {
            return this.filterObject;
        }

        public void setReturnObject(Object returnObject) {
            this.returnObject = returnObject;
        }

        public Object getReturnObject() {
            return this.returnObject;
        }

        void setThis(Object target) {
            this.target = target;
        }

        public Object getThis() {
            return this.target;
        }
    }

    @Component
    static class ShiroLikeMethodSecurityExpressionHandler
    extends DefaultMethodSecurityExpressionHandler {
        ShiroLikeMethodSecurityExpressionHandler() {
        }

        protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
            ShiroLikeMethodSecurityExpressionRoot root = new ShiroLikeMethodSecurityExpressionRoot(authentication);
            root.setThis(invocation.getThis());
            root.setPermissionEvaluator(this.getPermissionEvaluator());
            root.setTrustResolver(this.getTrustResolver());
            root.setRoleHierarchy(this.getRoleHierarchy());
            root.setDefaultRolePrefix(this.getDefaultRolePrefix());
            return root;
        }
    }
}

