/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot.security.rpc;

import net.turnbig.pandora.springboot.security.rpc.filter.JsonPayloadAuthenticationFilter;
import net.turnbig.pandora.springboot.security.rpc.handler.RpcAuthenticationPostHandler;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class RpcLoginConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractAuthenticationFilterConfigurer<H, RpcLoginConfigurer<H>, JsonPayloadAuthenticationFilter> {
    private final StringRedisTemplate stringRedisTemplate;

    public RpcLoginConfigurer(String usernamePath, String passwordPath, StringRedisTemplate stringRedisTemplate) {
        this(usernamePath, passwordPath, null, stringRedisTemplate);
    }

    public RpcLoginConfigurer(String usernamePath, String passwordPath, String loginProcessingUrl, StringRedisTemplate stringRedisTemplate) {
        super((AbstractAuthenticationProcessingFilter)new JsonPayloadAuthenticationFilter(usernamePath, passwordPath), loginProcessingUrl);
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void init(H http) throws Exception {
        super.init(http);
        RpcAuthenticationPostHandler handler = new RpcAuthenticationPostHandler(this.stringRedisTemplate);
        this.successHandler(handler);
        this.failureHandler(handler);
    }

    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl, "POST");
    }

    public RpcLoginConfigurer<H> usernamePath(String usernamePath) {
        ((JsonPayloadAuthenticationFilter)this.getAuthenticationFilter()).setUsernamePath(usernamePath);
        return this;
    }

    public RpcLoginConfigurer<H> passwordPath(String passwordPath) {
        ((JsonPayloadAuthenticationFilter)this.getAuthenticationFilter()).setPasswordPath(passwordPath);
        return this;
    }
}

