/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot.security.rpc;

import javax.servlet.Filter;
import net.turnbig.pandora.springboot.security.ShiroLikeMethodSecurityConfiguration;
import net.turnbig.pandora.springboot.security.rpc.RpcLoginConfigurer;
import net.turnbig.pandora.springboot.security.rpc.SpringSecurityRpcProperties;
import net.turnbig.pandora.springboot.security.rpc.filter.JsonPayloadAuthenticationFilter;
import net.turnbig.pandora.springboot.security.rpc.filter.TokenHeaderAuthenticationFilter;
import net.turnbig.pandora.springboot.security.rpc.handler.RpcAccessDeniedHandler;
import net.turnbig.pandora.springboot.security.rpc.handler.RpcLogoutHandler;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@EnableConfigurationProperties(value={SpringSecurityRpcProperties.class})
@Import(value={ShiroLikeMethodSecurityConfiguration.class})
public class SpringSecurityRpcConfiguration
extends WebSecurityConfigurerAdapter {
    private final SpringSecurityRpcProperties properties;
    private final UserDetailsService userDetailsService;
    private final StringRedisTemplate stringRedisTemplate;

    public SpringSecurityRpcConfiguration(SpringSecurityRpcProperties properties, UserDetailsService userDetailsService, StringRedisTemplate stringRedisTemplate) {
        this.properties = properties;
        this.userDetailsService = userDetailsService;
        this.stringRedisTemplate = stringRedisTemplate;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.antMatchers(HttpMethod.OPTIONS)).permitAll().antMatchers(this.properties.getAnonUrls())).permitAll().antMatchers(new String[]{this.properties.getLoginUrl()})).permitAll().antMatchers(new String[]{this.properties.getLogoutUrl()})).permitAll().anyRequest()).authenticated()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        if (this.properties.isDisableCsrf()) {
            http.csrf().disable();
        }
        this.configureRpcAuthentication(http);
    }

    private void configureRpcAuthentication(HttpSecurity http) throws Exception {
        RpcLoginConfigurer rpcLoginConfigurer = new RpcLoginConfigurer("$.username", "$.password", this.properties.getLoginUrl(), this.stringRedisTemplate);
        http.apply(rpcLoginConfigurer);
        TokenHeaderAuthenticationFilter tokenHeaderAuthenticationFilter = new TokenHeaderAuthenticationFilter(this.stringRedisTemplate, this.userDetailsService);
        http.addFilterBefore((Filter)tokenHeaderAuthenticationFilter, JsonPayloadAuthenticationFilter.class);
        RpcAccessDeniedHandler accessDeniedHandler = new RpcAccessDeniedHandler();
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)accessDeniedHandler).accessDeniedHandler((AccessDeniedHandler)accessDeniedHandler);
        RpcLogoutHandler logoutHandler = new RpcLogoutHandler(this.stringRedisTemplate);
        http.logout().logoutUrl(this.properties.getLogoutUrl()).addLogoutHandler((LogoutHandler)logoutHandler).logoutSuccessHandler((LogoutSuccessHandler)logoutHandler);
    }

    @Bean(name={"org.springframework.security.authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

