/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot.security.rpc.filter;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JsonPayloadAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(JsonPayloadAuthenticationFilter.class);
    String usernamePath;
    String passwordPath;

    public JsonPayloadAuthenticationFilter(String usernamePath, String passwordPath) {
        this.usernamePath = usernamePath;
        this.passwordPath = passwordPath;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        UsernamePasswordAuthenticationToken token;
        try (ServletInputStream is = request.getInputStream();){
            DocumentContext payload = JsonPath.parse((InputStream)is);
            String username = (String)payload.read(this.usernamePath, String.class, new Predicate[0]);
            String password = (String)payload.read(this.passwordPath, String.class, new Predicate[0]);
            token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        }
        catch (IOException e) {
            log.error("Could not load authentication payload", (Throwable)e);
            token = new UsernamePasswordAuthenticationToken((Object)"", (Object)"");
        }
        this.setDetails(request, token);
        return this.getAuthenticationManager().authenticate((Authentication)token);
    }

    public void setUsernamePath(String usernamePath) {
        this.usernamePath = usernamePath;
    }

    public void setPasswordPath(String passwordPath) {
        this.passwordPath = passwordPath;
    }
}

