/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot.security.rpc.filter;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.turnbig.pandora.springboot.security.rpc.RpcSecurityConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class TokenHeaderAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(TokenHeaderAuthenticationFilter.class);
    WebAuthenticationDetailsSource webAuthenticationDetailsSource = new WebAuthenticationDetailsSource();
    StringRedisTemplate redisTemplate;
    UserDetailsService userDetailsService;

    public TokenHeaderAuthenticationFilter(StringRedisTemplate redisTemplate, UserDetailsService userDetailsService) {
        this.redisTemplate = redisTemplate;
        this.userDetailsService = userDetailsService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String tokenRedisHashKey;
        Set keys;
        String token = request.getHeader("X-Auth-Token");
        if (token != null && (keys = this.redisTemplate.keys((Object)(tokenRedisHashKey = RpcSecurityConstants.getAuthenticationTokenRedisKeyName(token, "*")))) != null && keys.size() == 1) {
            ValueOperations tokenOps = this.redisTemplate.opsForValue();
            String tokenRedisKey = (String)keys.iterator().next();
            String username = (String)tokenOps.get((Object)tokenRedisKey);
            this.redisTemplate.expire((Object)tokenRedisKey, 30L, TimeUnit.MINUTES);
            if (username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)this.webAuthenticationDetailsSource.buildDetails(request));
                this.logger.info((Object)("Authenticate user `" + username + "` by token successfully."));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

