/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot.security.rpc.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.turnbig.pandora.mapper.JsonMapper;
import net.turnbig.pandora.web.Servlets;
import net.turnbig.pandora.web.springmvc.view.Result;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

public class RpcAccessDeniedHandler
implements AuthenticationEntryPoint,
AccessDeniedHandler {
    public static final int CODE_LOGIN_REQUIRED = 4010;
    public static final int CODE_NOT_PERMIT = 4011;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        Result loginRequired = Result.failed(4010, "login required");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        Servlets.output(response, "application/json", JsonMapper.nonEmptyMapper().toJson(loginRequired));
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        Result loginRequired = Result.failed(4011, "not permit");
        response.setStatus(HttpStatus.FORBIDDEN.value());
        Servlets.output(response, "application/json", JsonMapper.nonEmptyMapper().toJson(loginRequired));
    }
}

