/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.springboot.security.rpc.handler;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.turnbig.pandora.mapper.JsonMapper;
import net.turnbig.pandora.springboot.security.rpc.RpcSecurityConstants;
import net.turnbig.pandora.springboot.security.rpc.RpcUserDetails;
import net.turnbig.pandora.web.Servlets;
import net.turnbig.pandora.web.springmvc.view.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class RpcAuthenticationPostHandler
implements AuthenticationSuccessHandler,
AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcAuthenticationPostHandler.class);
    StringRedisTemplate stringRedisTemplate;

    public RpcAuthenticationPostHandler(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        Set keys;
        log.info("User `{}` login successfully.", (Object)authentication.getName());
        RpcUserDetails userDetails = (RpcUserDetails)authentication.getPrincipal();
        String token = null;
        while ((keys = this.stringRedisTemplate.keys((Object)RpcSecurityConstants.getAuthenticationTokenRedisKeyName(token = UUID.randomUUID().toString(), "*"))) != null && keys.size() != 0) {
        }
        String authenticationTokenRedisKeyName = RpcSecurityConstants.getAuthenticationTokenRedisKeyName(token, userDetails.getIdentify());
        ValueOperations tokenOps = this.stringRedisTemplate.opsForValue();
        tokenOps.set((Object)authenticationTokenRedisKeyName, (Object)userDetails.getUsername());
        this.stringRedisTemplate.expire((Object)authenticationTokenRedisKeyName, 30L, TimeUnit.MINUTES);
        Map<String, Object> profile = userDetails.profile();
        profile.put("token", token);
        Result success = Result.success(profile);
        Servlets.output(response, "application/json", JsonMapper.nonEmptyMapper().toJson(success));
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        log.info("User login failed, reason:: {}", (Object)exception.getMessage());
        Result failed = Result.failed(10000, exception.getMessage());
        String content = JsonMapper.nonEmptyMapper().toJson(failed);
        Servlets.output(response, "application/json", content);
    }
}

