/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.storage;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import net.turnbig.pandora.storage.CloudFileHandler;
import net.turnbig.pandora.storage.TempFolderUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class FileSystemFileHandler
extends CloudFileHandler {
    @Value(value="${pro.storage}")
    private String storage;

    @Override
    public String upload(File file, String name, String bucket, CloudFileHandler.FileMeta meta) {
        String relatedPath = TempFolderUtils.build(Lists.newArrayList((Object[])new String[]{(String)StringUtils.defaultIfBlank((CharSequence)bucket, (CharSequence)""), name}));
        String filepath = TempFolderUtils.build(Lists.newArrayList((Object[])new String[]{this.storage, relatedPath}));
        try {
            FileUtils.copyFile((File)file, (File)new File(filepath));
        }
        catch (IOException e) {
            logger.error("Could not upload file to bucket[{}], name[{}]", (Object)bucket, (Object)name);
            logger.error("Failed to save file to local storage", (Throwable)e);
        }
        if (relatedPath.startsWith("/")) {
            return StringUtils.replace((String)relatedPath, (String)"\\", (String)"/");
        }
        return "/" + StringUtils.replace((String)relatedPath, (String)"\\", (String)"/");
    }

    @Override
    public String upload(byte[] content, String name, String bucket, CloudFileHandler.FileMeta meta) {
        String relatedPath = TempFolderUtils.build(Lists.newArrayList((Object[])new String[]{(String)StringUtils.defaultIfBlank((CharSequence)bucket, (CharSequence)""), name}));
        String filepath = TempFolderUtils.build(Lists.newArrayList((Object[])new String[]{this.storage, relatedPath}));
        try {
            FileUtils.writeByteArrayToFile((File)new File(filepath), (byte[])content);
        }
        catch (IOException e) {
            logger.error("Could not upload file to bucket[{}], name[{}]", (Object)bucket, (Object)name);
            logger.error("Failed to save file to local storage", (Throwable)e);
        }
        if (relatedPath.startsWith("/")) {
            return StringUtils.replace((String)relatedPath, (String)"\\", (String)"/");
        }
        return "/" + StringUtils.replace((String)relatedPath, (String)"\\", (String)"/");
    }

    @Override
    public String getUrl(String key) {
        throw new RuntimeException("not implemented");
    }
}

