/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.meta.InsertOnly;
import com.qcloud.cos.request.UpdateFileRequest;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import java.io.File;
import java.io.IOException;
import net.turnbig.pandora.mapper.JsonMapper;
import net.turnbig.pandora.storage.CloudFileHandler;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;

public class QCloudFileHandler
extends CloudFileHandler
implements InitializingBean {
    @Autowired
    QCloudProperties properties;
    COSClient COS;

    public void afterPropertiesSet() throws Exception {
        ClientConfig config = new ClientConfig();
        config.setRegion(this.properties.getRegion());
        config.setMaxFailedRetry(5);
        Credentials credential = new Credentials(this.properties.getAppId().longValue(), this.properties.getSecretId(), this.properties.getSecretKey());
        this.COS = new COSClient(config, credential);
    }

    @Override
    public String upload(File file, String filename, String bucket, CloudFileHandler.FileMeta meta) {
        if (!filename.startsWith("/")) {
            filename = "/" + filename;
        }
        UploadFileRequest request = new UploadFileRequest(bucket, filename, file.getAbsolutePath());
        request.setInsertOnly(InsertOnly.NO_OVER_WRITE);
        request.setEnableShaDigest(false);
        return this.upload(request, meta);
    }

    @Override
    public String upload(byte[] content, String filename, String bucket, CloudFileHandler.FileMeta meta) {
        if (!filename.startsWith("/")) {
            filename = "/" + filename;
        }
        UploadFileRequest request = new UploadFileRequest(bucket, filename, content);
        request.setInsertOnly(InsertOnly.NO_OVER_WRITE);
        request.setEnableShaDigest(false);
        return this.upload(request, meta);
    }

    private String upload(UploadFileRequest request, CloudFileHandler.FileMeta meta) {
        String response = this.COS.uploadFile(request);
        String reason = "Failed to upload file to COS";
        try {
            JsonNode result = JsonMapper.nonDefaultMapper().getMapper().readTree(response);
            if (result.get("code") != null) {
                Integer code = result.get("code").asInt();
                if (code == 0) {
                    UpdateFileRequest updateFileMetaRequest = new UpdateFileRequest(request.getBucketName(), request.getCosPath());
                    if (StringUtils.isNotBlank((CharSequence)meta.getFileName())) {
                        updateFileMetaRequest.setXCosMeta("x-cos-meta-filename", meta.getFileName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)meta.getContentType())) {
                        updateFileMetaRequest.setContentType(meta.getContentType());
                    }
                    if (StringUtils.isNotBlank((CharSequence)meta.getContentEncoding())) {
                        updateFileMetaRequest.setContentEncoding(meta.getContentEncoding());
                    }
                    this.COS.updateFile(updateFileMetaRequest);
                    return result.get("data").get("resource_path").asText();
                }
                reason = result.get("message").toString();
            }
        }
        catch (IOException e) {
            logger.error("Failed to upload file to QCloud COS", (Throwable)e);
        }
        logger.warn("Failed to upload file to COS, response is: {}", (Object)response);
        throw new RuntimeException(reason);
    }

    @Override
    public String getUrl(String key) {
        return null;
    }

    public void setProperties(QCloudProperties properties) {
        this.properties = properties;
    }

    @ConfigurationProperties(prefix="qcloud.cos")
    public static class QCloudProperties {
        Long appId;
        String secretId;
        String secretKey;
        String region;

        public Long getAppId() {
            return this.appId;
        }

        public String getSecretId() {
            return this.secretId;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getRegion() {
            return this.region;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setRegion(String region) {
            this.region = region;
        }
    }
}

