/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import net.turnbig.pandora.storage.CloudFileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class QiniuFileHandler
extends CloudFileHandler {
    private static final Logger logger = LoggerFactory.getLogger(QiniuFileHandler.class);
    @Value(value="${qiniu.ak}")
    String ak;
    @Value(value="${qiniu.sk}")
    String sk;
    @Value(value="${qiniu.cdn}")
    String cdn;
    Auth auth;
    UploadManager uploader;

    @PostConstruct
    public void init() {
        this.auth = Auth.create((String)this.ak, (String)this.sk);
        this.uploader = new UploadManager(null);
    }

    public String getUploadToken(String bucket) {
        return this.auth.uploadToken(bucket);
    }

    @Override
    public String upload(File file, String name, String bucket, CloudFileHandler.FileMeta meta) {
        try {
            Response res = this.uploader.put(file.getAbsolutePath(), name, this.getUploadToken(bucket));
            if (res.isOK()) {
                StringMap result = res.jsonToMap();
                return result.get("key").toString();
            }
            logger.error("Failed to upload file to Qiniu Cloud, response is {}", (Object)res);
            return null;
        }
        catch (QiniuException e) {
            logger.error("Failed to upload file to Qiniu Cloud", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String upload(byte[] content, String name, String bucket, CloudFileHandler.FileMeta meta) {
        try {
            Response res = this.uploader.put(content, name, this.getUploadToken(bucket));
            if (res.isOK()) {
                StringMap result = res.jsonToMap();
                return result.get("key").toString();
            }
            logger.error("Failed to upload file to Qiniu Cloud, response is {}", (Object)res);
            return null;
        }
        catch (QiniuException e) {
            logger.error("Failed to upload file to Qiniu Cloud", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getRequireTokenUrl(String url) {
        String downloadUrl = this.auth.privateDownloadUrl(url, 3600L);
        return downloadUrl;
    }

    @Override
    public String getUrl(String key) {
        String url = this.cdn + key;
        return url;
    }

    public static void main(String[] args) throws IOException {
    }
}

