/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.storage;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TempFolderUtils {
    private static final Logger logger = LoggerFactory.getLogger(TempFolderUtils.class);
    private static final int RANDOM_LEN = 30;
    @Resource
    Properties props;
    @Value(value="${project.temp.folder:}")
    String configedTempFolder;
    public static String tempFolderPath;

    @PostConstruct
    public void init() {
        if (tempFolderPath == null) {
            logger.info("Initial System temp folder path ...");
            String defaultTempFolder = System.getProperty("user.home") + File.separator + "temp";
            tempFolderPath = StringUtils.isNotBlank((CharSequence)this.configedTempFolder) ? this.configedTempFolder : defaultTempFolder;
            File file = new File(tempFolderPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            logger.info("System temp folder path: {}", (Object)file.getAbsoluteFile().getAbsolutePath());
        }
    }

    public static String getAbsTempFilePath(String ... relativePath) {
        ArrayList segments = Lists.newArrayList((Object[])relativePath);
        segments.add(0, tempFolderPath);
        return TempFolderUtils.build(segments);
    }

    public static String build(List<String> segments) {
        return FilenameUtils.normalize((String)StringUtils.join(segments, (String)File.separator).trim());
    }

    public static String getRandomFileName(String prefix, String ext) {
        String file = StringUtils.appendIfMissing((String)StringUtils.defaultString((String)prefix, (String)""), (CharSequence)File.separator, (CharSequence[])new CharSequence[0]) + RandomStringUtils.randomAlphanumeric((int)30);
        return file + (StringUtils.isBlank((CharSequence)ext) ? "" : "." + ext);
    }

    public static void main(String[] args) {
    }
}

