/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.turnbig.pandora.utils.Reflections;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class Collections3 {
    public static Map extractToMap(Collection collection, String keyPropertyName, String valuePropertyName) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(collection.size());
        try {
            for (Object obj : collection) {
                map.put(PropertyUtils.getProperty(obj, (String)keyPropertyName), PropertyUtils.getProperty(obj, (String)valuePropertyName));
            }
        }
        catch (Exception e) {
            throw Reflections.convertReflectionExceptionToUnchecked(e);
        }
        return map;
    }

    public static List extractToList(Collection collection, String propertyName) {
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        try {
            for (Object obj : collection) {
                list.add(PropertyUtils.getProperty(obj, (String)propertyName));
            }
        }
        catch (Exception e) {
            throw Reflections.convertReflectionExceptionToUnchecked(e);
        }
        return list;
    }

    public static String extractToString(Collection collection, String propertyName, String separator) {
        List list = Collections3.extractToList(collection, propertyName);
        return StringUtils.join((Iterable)list, (String)separator);
    }

    public static String convertToString(Collection collection, String separator) {
        return StringUtils.join((Iterable)collection, (String)separator);
    }

    public static String convertToString(Collection collection, String prefix, String postfix) {
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            builder.append(prefix).append(o).append(postfix);
        }
        return builder.toString();
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (Collections3.isEmpty(collection)) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <T> T getLast(Collection<T> collection) {
        T current;
        if (Collections3.isEmpty(collection)) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(list.size() - 1);
        }
        Iterator<T> iterator = collection.iterator();
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    public static <T> List<T> union(Collection<T> a, Collection<T> b) {
        ArrayList<T> result = new ArrayList<T>(a);
        result.addAll(b);
        return result;
    }

    public static <T> List<T> subtract(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>(a);
        for (T element : b) {
            list.remove(element);
        }
        return list;
    }

    public static <T> List<T> intersection(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : a) {
            if (!b.contains(element)) continue;
            list.add(element);
        }
        return list;
    }
}

