/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.utils;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateFormatUtils {
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormat.forPattern((String)"HH:mm:ss");
    private static Map<String, DateTimeFormatter> cache = Maps.newHashMap();

    public static DateTimeFormatter getFormatter(String pattern) {
        if (!cache.containsKey(pattern)) {
            cache.put(pattern, DateTimeFormat.forPattern((String)pattern));
        }
        return cache.get(pattern);
    }

    public static String getDatetime(Date date) {
        return DATETIME_FORMATTER.print((ReadableInstant)new DateTime((Object)date));
    }

    public static String getDatetime(DateTime date) {
        return DATETIME_FORMATTER.print((ReadableInstant)date);
    }

    public static String getDatetime(long millis) {
        return DateFormatUtils.getDatetime(new DateTime(millis));
    }

    public static String getString(DateTime date, String pattern) {
        return DateFormatUtils.getFormatter(pattern).print((ReadableInstant)date);
    }

    public static String getString(Date date, String pattern) {
        return DateFormatUtils.getString(new DateTime((Object)date), pattern);
    }

    public static String getString(long millis, String pattern) {
        return DateFormatUtils.getString(new DateTime(millis), pattern);
    }

    public static String getCurrentDatetime() {
        return DATETIME_FORMATTER.print((ReadableInstant)new DateTime());
    }

    public static String getCurrentDatetime(String pattern) {
        return DateFormatUtils.getString(DateTime.now(), pattern);
    }

    public static String getDate(DateTime date) {
        return DATE_FORMATTER.print((ReadableInstant)date);
    }

    public static String getDate(Date date) {
        return DateFormatUtils.getDate(new DateTime((Object)date));
    }

    public static String getDate(long millis) {
        return DateFormatUtils.getDate(new DateTime(millis));
    }

    public static String getCurrentDate() {
        return DateFormatUtils.getDate(DateTime.now());
    }

    public static String getTime(DateTime date) {
        return TIME_FORMATTER.print((ReadableInstant)date);
    }

    public static String getTime(Date date) {
        return DateFormatUtils.getTime(new DateTime((Object)date));
    }

    public static String getCurrentTime() {
        return DateFormatUtils.getTime(DateTime.now());
    }

    public static String getTime(long millis) {
        return DateFormatUtils.getTime(new DateTime(millis));
    }

    public static DateTime parse(String dateString, String pattern) {
        if (dateString == null) {
            throw new NullPointerException();
        }
        return DateFormatUtils.getFormatter(pattern).parseDateTime(dateString);
    }

    public static DateTime parse(String dateString) {
        if (dateString == null) {
            throw new NullPointerException();
        }
        if (dateString.contains("-") && dateString.contains(":")) {
            return DATETIME_FORMATTER.parseDateTime(dateString);
        }
        if (dateString.contains("-")) {
            return DATE_FORMATTER.parseDateTime(dateString);
        }
        dateString = DateFormatUtils.getCurrentDate() + " " + dateString;
        return DATETIME_FORMATTER.parseDateTime(dateString);
    }

    static {
        cache.put("yyyy-MM-dd HH:mm:ss", DATETIME_FORMATTER);
        cache.put("yyyy-MM-dd", DATE_FORMATTER);
        cache.put("HH:mm:ss", TIME_FORMATTER);
    }
}

