/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.utils;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.layout.font.FontProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class Html2Pdf {
    static final Logger logger = LoggerFactory.getLogger(Html2Pdf.class);
    static DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
    static ConverterProperties properties;
    static FontProvider CJKFontProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConverterProperties getDefaultConverterProperties() {
        if (properties == null) {
            DefaultResourceLoader defaultResourceLoader = resourceLoader;
            synchronized (defaultResourceLoader) {
                if (properties == null) {
                    properties = new ConverterProperties();
                    properties.setFontProvider(Html2Pdf.getDefaultCJKFontProvider());
                    properties.setCharset("UTF-8");
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontProvider getDefaultCJKFontProvider() {
        if (CJKFontProvider == null) {
            DefaultResourceLoader defaultResourceLoader = resourceLoader;
            synchronized (defaultResourceLoader) {
                if (CJKFontProvider == null) {
                    try {
                        CJKFontProvider = new FontProvider();
                        Resource kora = resourceLoader.getResource("malgun.ttf");
                        Resource japan = resourceLoader.getResource("msmincho.ttf");
                        Resource chinese = resourceLoader.getResource("pingfang-sc-light.otf");
                        CJKFontProvider.addFont(IOUtils.toByteArray((InputStream)kora.getInputStream()));
                        CJKFontProvider.addFont(IOUtils.toByteArray((InputStream)japan.getInputStream()));
                        CJKFontProvider.addFont(IOUtils.toByteArray((InputStream)chinese.getInputStream()));
                    }
                    catch (IOException e) {
                        logger.error("Failed to load pingfang sc light font type", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return CJKFontProvider;
    }

    public static void convert(File htmlFile, File targetPdfFile) throws IOException {
        HtmlConverter.convertToPdf((File)htmlFile, (File)targetPdfFile, (ConverterProperties)Html2Pdf.getDefaultConverterProperties());
    }

    public static void convert(File htmlFile, File targetPdfFile, String baseUri) throws IOException {
        ConverterProperties defaultConverterProperties = Html2Pdf.getDefaultConverterProperties();
        ConverterProperties copy = new ConverterProperties(defaultConverterProperties).setBaseUri(baseUri);
        HtmlConverter.convertToPdf((File)htmlFile, (File)targetPdfFile, (ConverterProperties)copy);
    }

    public static void convert(File htmlFile, File targetPdfFile, ConverterProperties properties) throws IOException {
        HtmlConverter.convertToPdf((File)htmlFile, (File)targetPdfFile, (ConverterProperties)properties);
    }

    public static void convert(String htmlContent, File targetPdfFile) throws IOException {
        HtmlConverter.convertToPdf((String)htmlContent, (OutputStream)new FileOutputStream(targetPdfFile), (ConverterProperties)Html2Pdf.getDefaultConverterProperties());
    }

    public static void convert(String htmlContent, File targetPdfFile, String baseUri) throws IOException {
        ConverterProperties defaultConverterProperties = Html2Pdf.getDefaultConverterProperties();
        ConverterProperties copy = new ConverterProperties(defaultConverterProperties).setBaseUri(baseUri);
        HtmlConverter.convertToPdf((String)htmlContent, (OutputStream)new FileOutputStream(targetPdfFile), (ConverterProperties)copy);
    }

    public static void convert(String htmlContent, File targetPdfFile, ConverterProperties properties) throws IOException {
        HtmlConverter.convertToPdf((String)htmlContent, (OutputStream)new FileOutputStream(targetPdfFile), (ConverterProperties)properties);
    }

    public static void main(String[] args) throws IOException {
        String contextFolder = "E:\\www\\express";
        String outputFileName = "QJ304501-0";
        File htmlFile = new File(contextFolder + File.separator + outputFileName + ".html");
        File pdfFile = new File(contextFolder + File.separator + outputFileName + ".pdf");
        Html2Pdf.convert(htmlFile, pdfFile);
    }
}

