/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.utils;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    static final Logger logger = LoggerFactory.getLogger(HttpClientFactory.class);
    static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36";
    static final String ENCODING = "UTF-8";
    private static HttpClientFactory instance;
    CloseableHttpClient client;

    private HttpClientFactory() {
    }

    public static HttpClientFactory create() {
        if (instance == null) {
            instance = new HttpClientFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpClient build() {
        if (this.client == null) {
            HttpClientFactory httpClientFactory = this;
            synchronized (httpClientFactory) {
                if (this.client == null) {
                    this.client = this.buildClient();
                }
            }
        }
        return this.client;
    }

    private CloseableHttpClient buildClient() {
        HttpClientBuilder httpBuilder = HttpClientBuilder.create();
        httpBuilder.setUserAgent(USER_AGENT);
        httpBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        httpBuilder.setMaxConnPerRoute(50);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(10000).setCookieSpec("default").build();
        httpBuilder.setDefaultRequestConfig(config);
        httpBuilder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new DefaultServiceUnavailableRetryStrategy(5, 5));
        httpBuilder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, true));
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build();
            httpBuilder.setSSLContext(sslContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpBuilder.build();
    }
}

