/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.utils;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import net.turnbig.pandora.utils.Encodes;
import net.turnbig.pandora.utils.HttpClientFactory;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

public class PDFUtils {
    static final MemoryUsageSetting MEMORY_USAGE = MemoryUsageSetting.setupMixed((long)0x300000L);

    public static void mergeFiles(List<String> sourceFiles, String targetFile, PDDocumentInformation docInfo) throws IOException {
        FileUtils.forceMkdirParent((File)new File(targetFile));
        PDFMergerUtility merger = new PDFMergerUtility();
        for (String sourceFile : sourceFiles) {
            merger.addSource(sourceFile);
        }
        merger.setDestinationDocumentInformation(docInfo);
        merger.setDestinationFileName(targetFile);
        merger.mergeDocuments(MEMORY_USAGE);
    }

    public static void mergeFiles(List<File> sourceFiles, File targetFile, PDDocumentInformation docInfo) throws IOException {
        FileUtils.forceMkdirParent((File)targetFile);
        PDFMergerUtility merger = new PDFMergerUtility();
        for (File sourceFile : sourceFiles) {
            merger.addSource(sourceFile);
        }
        merger.setDestinationDocumentInformation(docInfo);
        merger.setDestinationStream((OutputStream)new FileOutputStream(targetFile));
        merger.mergeDocuments(MEMORY_USAGE);
    }

    public static void mergeHttpRemoteFiles(List<String> urls, File targetFile, PDDocumentInformation docInfo) throws IOException {
        FileUtils.forceMkdirParent((File)targetFile);
        PDFMergerUtility merger = new PDFMergerUtility();
        for (String url : urls) {
            CloseableHttpClient http = HttpClientFactory.create().build();
            CloseableHttpResponse execute = http.execute(RequestBuilder.get((String)url).build());
            merger.addSource(execute.getEntity().getContent());
        }
        merger.setDestinationDocumentInformation(docInfo);
        merger.setDestinationStream((OutputStream)new FileOutputStream(targetFile));
        merger.mergeDocuments(MEMORY_USAGE);
    }

    public static void mergeHttpRemoteFiles(List<String> urls, OutputStream targetOutputStream, PDDocumentInformation docInfo) throws IOException {
        PDFMergerUtility merger = new PDFMergerUtility();
        for (String url : urls) {
            CloseableHttpClient http = HttpClientFactory.create().build();
            CloseableHttpResponse execute = http.execute(RequestBuilder.get((String)Encodes.uriEncode(url)).build());
            merger.addSource(execute.getEntity().getContent());
        }
        merger.setDestinationDocumentInformation(docInfo);
        merger.setDestinationStream(targetOutputStream);
        merger.mergeDocuments(MEMORY_USAGE);
    }

    public static PDDocumentInformation buildDocInfo(String author, String producer) {
        PDDocumentInformation info = new PDDocumentInformation();
        info.setAuthor(author);
        info.setProducer(producer);
        info.setCreationDate(Calendar.getInstance(Locale.CHINA));
        return info;
    }

    public static void main(String[] args) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PDFUtils.mergeHttpRemoteFiles((List<String>)Lists.newArrayList((Object[])new String[]{"http://l1-1252321162.cossh.myqcloud.com/order/voucher/ArVqwyFODHgWpsiMFHRRckisAFeUaY.pdf"}), bos, PDFUtils.buildDocInfo("jarvis@turnbig.net", "www.turnbig.net"));
        FileUtils.writeByteArrayToFile((File)new File("6.pdf"), (byte[])bos.toByteArray());
    }
}

