/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.turnbig.pandora.utils.Collections3;
import net.turnbig.pandora.utils.Encodes;
import org.apache.commons.lang3.StringUtils;

public class Servlets {
    public static final long ONE_YEAR_SECONDS = 31536000L;

    public static void setExpiresHeader(HttpServletResponse response, long expiresSeconds) {
        response.setDateHeader("Expires", System.currentTimeMillis() + expiresSeconds * 1000L);
        response.setHeader("Cache-Control", "private, max-age=" + expiresSeconds);
    }

    public static void setNoCacheHeader(HttpServletResponse response) {
        response.setDateHeader("Expires", 1L);
        response.addHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
    }

    public static void setLastModifiedHeader(HttpServletResponse response, long lastModifiedDate) {
        response.setDateHeader("Last-Modified", lastModifiedDate);
    }

    public static void setEtag(HttpServletResponse response, String etag) {
        response.setHeader("ETag", etag);
    }

    public static boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, long lastModified) {
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince != -1L && lastModified < ifModifiedSince + 1000L) {
            response.setStatus(304);
            return false;
        }
        return true;
    }

    public static boolean checkIfNoneMatchEtag(HttpServletRequest request, HttpServletResponse response, String etag) {
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!"*".equals(headerValue)) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(etag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                response.setStatus(304);
                response.setHeader("ETag", etag);
                return false;
            }
        }
        return true;
    }

    public static void setFileDownloadHeader(HttpServletRequest request, HttpServletResponse response, String fileName) {
        try {
            String agent = request.getHeader("User-Agent");
            boolean isMSIE = agent != null && agent.indexOf("MSIE") != -1;
            String encoded = isMSIE ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encoded + "\"");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static Map<String, Object> getParametersStartingWith(ServletRequest request, String prefix) {
        String prefix_;
        Enumeration paramNames = request.getParameterNames();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        String string = prefix_ = prefix == null ? "" : prefix;
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!"".equals(prefix_) && !paramName.startsWith(prefix_)) continue;
            String unprefixed = paramName.substring(prefix_.length());
            String[] values = request.getParameterValues(paramName);
            if (values == null || values.length == 0) continue;
            if (values.length > 1) {
                params.put(unprefixed, values);
                continue;
            }
            params.put(unprefixed, values[0]);
        }
        return params;
    }

    public static Map<String, Object> getParameters(ServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] values = request.getParameterValues(paramName);
            if (values == null || values.length == 0) continue;
            if (values.length > 1) {
                params.put(paramName, values);
                continue;
            }
            params.put(paramName, values[0]);
        }
        return params;
    }

    public static String encodeParameterStringWithPrefix(Map<String, Object> params, String prefix) {
        if (params == null || params.size() == 0) {
            return "";
        }
        String prefix_ = prefix == null ? "" : prefix;
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object values = entry.getValue();
            if (values instanceof String[]) {
                for (String v : (String[])values) {
                    list.add(String.format("%s%s=%s", prefix_, entry.getKey(), v));
                }
                continue;
            }
            if (!(values instanceof String)) continue;
            list.add(String.format("%s%s=%s", prefix_, entry.getKey(), values));
        }
        return Collections3.convertToString(list, "&");
    }

    public static String encodeHttpBasic(String userName, String password) {
        String encode = userName + ":" + password;
        return "Basic " + Encodes.encodeBase64(encode.getBytes());
    }

    public static String getBasePath(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        String requestURI = request.getRequestURI();
        String host = StringUtils.substringBeforeLast((String)requestURL, (String)requestURI);
        String contextPath = request.getContextPath();
        return StringUtils.removeEnd((String)(host + contextPath), (String)"/");
    }

    public static String getRelatedpath(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        return StringUtils.removeStart((String)requestURI, (String)contextPath);
    }

    public static String getHost(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        String requestURI = request.getRequestURI();
        String host = StringUtils.substringBefore((String)requestURL, (String)requestURI);
        return host;
    }

    public static String getIp(HttpServletRequest request) {
        String[] split;
        String xforward = request.getHeader("x-forwarded-for");
        if (StringUtils.isNotEmpty((CharSequence)xforward) && (split = StringUtils.split((String)xforward, (String)".")).length == 4) {
            return xforward;
        }
        return request.getRemoteAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void output(HttpServletResponse response, String contentType, String content) throws IOException {
        PrintWriter writer = response.getWriter();
        try {
            response.setContentType(contentType);
            writer.write(content);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }
}

