/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisConnectionFactory;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.HeaderHttpSessionIdResolver;
import org.springframework.session.web.http.HttpSessionIdResolver;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisSessionProperties.class})
@AutoConfigureBefore(value={RedisHttpSessionConfiguration.class})
public class RedisHttpSessionConfig {
    final RedisSessionProperties properties;
    protected RedisConnectionFactory redisConnectionFactory;

    public RedisHttpSessionConfig(RedisSessionProperties properties) {
        this.properties = properties;
    }

    @Autowired
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public void redisSessionConnectionFactory(GenericApplicationContext context) {
        BeanDefinition primary = context.getBeanDefinition("redisConnectionFactory");
        primary.setPrimary(true);
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(this.properties.getHost());
        config.setPort(this.properties.getPort());
        config.setPassword(this.properties.getPassword());
        config.setDatabase(this.properties.getDatabase());
        LettuceConnectionFactory factory = new LettuceConnectionFactory(config);
        context.registerBean("redisSessionConnectionFactory", RedisConnectionFactory.class, () -> factory, new BeanDefinitionCustomizer[]{bd -> {
            RootBeanDefinition rbd = (RootBeanDefinition)bd;
            rbd.addQualifier(new AutowireCandidateQualifier(SpringSessionRedisConnectionFactory.class));
        }});
    }

    @Bean
    public HttpSessionIdResolver httpSessionIdResolver() {
        HeaderHttpSessionIdResolver first = HeaderHttpSessionIdResolver.xAuthToken();
        CookieHttpSessionIdResolver second = new CookieHttpSessionIdResolver();
        return new CompositeHttpSessionIdResolver((HttpSessionIdResolver)first, (HttpSessionIdResolver)second);
    }

    public static class CompositeHttpSessionIdResolver
    implements HttpSessionIdResolver {
        List<HttpSessionIdResolver> resolvers = new ArrayList<HttpSessionIdResolver>();

        public CompositeHttpSessionIdResolver(HttpSessionIdResolver first) {
            this.resolvers.add(first);
        }

        public CompositeHttpSessionIdResolver(HttpSessionIdResolver first, HttpSessionIdResolver second) {
            this.resolvers.add(first);
            this.resolvers.add(second);
        }

        public void addResolver(HttpSessionIdResolver resolver) {
            this.resolvers.add(resolver);
        }

        public List<String> resolveSessionIds(HttpServletRequest request) {
            for (HttpSessionIdResolver resolver : this.resolvers) {
                List sessionIds = resolver.resolveSessionIds(request);
                if (sessionIds == null || sessionIds.isEmpty()) continue;
                return sessionIds;
            }
            return Collections.emptyList();
        }

        public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
            for (HttpSessionIdResolver resolver : this.resolvers) {
                resolver.setSessionId(request, response, sessionId);
            }
        }

        public void expireSession(HttpServletRequest request, HttpServletResponse response) {
            for (HttpSessionIdResolver resolver : this.resolvers) {
                resolver.expireSession(request, response);
            }
        }
    }

    @ConfigurationProperties(prefix="spring.session.redis")
    public static class RedisSessionProperties {
        String host = "127.0.0.1";
        String password;
        int database = 1;
        int port = 6379;

        public String getHost() {
            return this.host;
        }

        public String getPassword() {
            return this.password;
        }

        public int getDatabase() {
            return this.database;
        }

        public int getPort() {
            return this.port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setDatabase(int database) {
            this.database = database;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RedisSessionProperties)) {
                return false;
            }
            RedisSessionProperties other = (RedisSessionProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            if (this.getDatabase() != other.getDatabase()) {
                return false;
            }
            return this.getPort() == other.getPort();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RedisSessionProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            result = result * 59 + this.getDatabase();
            result = result * 59 + this.getPort();
            return result;
        }

        public String toString() {
            return "RedisHttpSessionConfig.RedisSessionProperties(host=" + this.getHost() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", port=" + this.getPort() + ")";
        }
    }
}

